class ConvTranspose1d(Module):
  __parameters__ = ["bias", "weight", ]
  __buffers__ = []
  bias : Optional[Tensor]
  weight : Tensor
  training : bool
  _is_full_backward_hook : NoneType
  transposed : bool
  _reversed_padding_repeated_twice : List[int]
  stride : Final[Tuple[int]] = (2,)
  out_channels : Final[int] = 16
  in_channels : Final[int] = 16
  groups : Final[int] = 1
  padding_mode : Final[str] = "zeros"
  padding : Final[Tuple[int]] = (1,)
  output_padding : Final[Tuple[int]] = (0,)
  kernel_size : Final[Tuple[int]] = (4,)
  dilation : Final[Tuple[int]] = (1,)
  def forward(self: __torch__.torch.nn.modules.conv.___torch_mangle_49.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]]=None) -> Tensor:
    output_padding = (self)._output_padding(input, output_size, [2], [1], [4], 1, [1], )
    weight = self.weight
    bias = self.bias
    _0 = torch.conv_transpose1d(input, weight, bias, [2], [1], output_padding, 1, [1])
    return _0
  def _output_padding(self: __torch__.torch.nn.modules.conv.___torch_mangle_49.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]],
    stride: List[int],
    padding: List[int],
    kernel_size: List[int],
    num_spatial_dims: int,
    dilation: Optional[List[int]]=None) -> List[int]:
    _1 = "ConvTranspose{}D: for {}D input, output_size must have {} or {} elements (got {})"
    _2 = "requested an output size of {}, but valid sizes range from {} to {} (for an input of {})"
    if torch.__is__(output_size, None):
      ret = [0]
    else:
      output_size0 = unchecked_cast(List[int], output_size)
      has_batch_dim = torch.eq(torch.dim(input), torch.add(num_spatial_dims, 2))
      if has_batch_dim:
        num_non_spatial_dims = 2
      else:
        num_non_spatial_dims = 1
      _3 = torch.len(output_size0)
      _4 = torch.add(num_non_spatial_dims, num_spatial_dims)
      if torch.eq(_3, _4):
        output_size2 = torch.slice(output_size0, num_non_spatial_dims)
        output_size1 = output_size2
      else:
        output_size1 = output_size0
      _5 = torch.ne(torch.len(output_size1), num_spatial_dims)
      if _5:
        _6 = torch.dim(input)
        _7 = torch.add(num_non_spatial_dims, num_spatial_dims)
        _8 = torch.format(_1, num_spatial_dims, _6, num_spatial_dims, _7, torch.len(output_size1))
        ops.prim.RaiseException(_8, "builtins.ValueError")
      else:
        pass
      min_sizes = annotate(List[int], [])
      max_sizes = annotate(List[int], [])
      dilation0: Optional[List[int]] = dilation
      for d in range(num_spatial_dims):
        _9 = torch.add(d, num_non_spatial_dims)
        _10 = torch.sub(torch.size(input, _9), 1)
        _11 = torch.sub(torch.mul(_10, stride[d]), torch.mul(2, padding[d]))
        _12 = torch.__isnot__(dilation0, None)
        if _12:
          dilation2 = unchecked_cast(List[int], dilation0)
          _13, dilation1 = dilation2[d], dilation2
        else:
          _13, dilation1 = 1, dilation0
        _14 = torch.mul(_13, torch.sub(kernel_size[d], 1))
        dim_size = torch.add(torch.add(_11, _14), 1)
        _15 = torch.append(min_sizes, dim_size)
        _16 = torch.add(min_sizes[d], stride[d])
        _17 = torch.append(max_sizes, torch.sub(_16, 1))
        dilation0 = dilation1
      for i in range(torch.len(output_size1)):
        size = output_size1[i]
        min_size = min_sizes[i]
        max_size = max_sizes[i]
        if torch.lt(size, min_size):
          _18 = True
        else:
          _18 = torch.gt(size, max_size)
        if _18:
          _19 = torch.slice(torch.size(input), 2)
          _20 = torch.format(_2, output_size1, min_sizes, max_sizes, _19)
          ops.prim.RaiseException(_20, "builtins.ValueError")
        else:
          pass
      res = annotate(List[int], [])
      for d0 in range(num_spatial_dims):
        _21 = torch.sub(output_size1[d0], min_sizes[d0])
        _22 = torch.append(res, _21)
      ret = res
    return ret
