class JitMultiForward(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  device : Device
  n_mel_channels : int
  encoder_type : str
  pitch_strength : float
  padding_value : float
  log_dur : bool
  embedding : __torch__.torch.nn.modules.sparse.Embedding
  speaker_embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_0.Embedding
  encoder : __torch__.tacotron2.fastpitch_layers.ForwardTransformer
  len_reg : __torch__.tacotron2.forward_layers.LengthRegulator
  pitch_proj : __torch__.torch.nn.modules.conv.___torch_mangle_2.Conv1d
  decoder : __torch__.tacotron2.fastpitch_layers.HourGlassTransformer
  lin : __torch__.torch.nn.modules.linear.___torch_mangle_5.Linear
  def forward(self: __torch__.jit_forward_model.JitMultiForward,
    inputs: Tensor,
    speaker_ids: Tensor,
    orig_mask: Tensor,
    dur_hat: Tensor,
    pitch_hat: Tensor) -> Tensor:
    embedding = self.embedding
    cond_embedded_inputs = (embedding).forward(inputs, )
    seq_len = torch.size(cond_embedded_inputs, 1)
    speaker_embedding = self.speaker_embedding
    _0 = (speaker_embedding).forward(speaker_ids, )
    speaker_embeds = torch.repeat(torch.unsqueeze(_0, 1), [1, seq_len, 1])
    encoder = self.encoder
    encoder_outputs = (encoder).forward(cond_embedded_inputs, orig_mask, None, )
    cond_encoder_outputs = torch.add(encoder_outputs, speaker_embeds)
    pitch_proj = self.pitch_proj
    pitch_proj0 = (pitch_proj).forward(pitch_hat, )
    pitch_proj1 = torch.transpose(pitch_proj0, 1, 2)
    pitch_strength = self.pitch_strength
    _1 = torch.mul(pitch_proj1, pitch_strength)
    cond_encoder_outputs0 = torch.add(cond_encoder_outputs, _1)
    len_reg = self.len_reg
    encoder_outputs_expanded = (len_reg).forward(cond_encoder_outputs0, dur_hat, )
    decoder = self.decoder
    outputs_expanded = (decoder).forward(encoder_outputs_expanded, None, None, )
    lin = self.lin
    mel_outputs = (lin).forward(outputs_expanded, )
    return torch.transpose(mel_outputs, 1, 2)
class JitDurPredictor(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  device : Device
  dur_class_type : NoneType
  log_dur : bool
  speaker_emb : str
  dur_pred : __torch__.jit_forward_model.TransformerSeriesPredictor
  def forward(self: __torch__.jit_forward_model.JitDurPredictor,
    text: Tensor,
    speaker_ids: Tensor,
    orig_mask: Optional[Tensor]=None,
    alpha: float=1.) -> Tensor:
    dur_pred = self.dur_pred
    dur_hat = (dur_pred).forward(text, speaker_ids, orig_mask, alpha, )
    return torch.squeeze(dur_hat, -1)
class TransformerSeriesPredictor(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  speaker_emb : str
  embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_57.Embedding
  transformer : __torch__.tacotron2.fastpitch_layers.___torch_mangle_67.ForwardTransformer
  lin : __torch__.torch.nn.modules.linear.___torch_mangle_68.Linear
  speaker_embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_69.Embedding
  def forward(self: __torch__.jit_forward_model.TransformerSeriesPredictor,
    x: Tensor,
    speaker_ids: Tensor,
    src_pad_mask: Optional[Tensor]=None,
    alpha: float=1.) -> Tensor:
    embedding = self.embedding
    x0 = (embedding).forward(x, )
    seq_len = torch.size(x0, 1)
    speaker_embedding = self.speaker_embedding
    _2 = (speaker_embedding).forward(speaker_ids, )
    speaker_embeds = torch.repeat(torch.unsqueeze(_2, 1), [1, seq_len, 1])
    x1 = torch.add(x0, speaker_embeds)
    transformer = self.transformer
    x2 = (transformer).forward(x1, src_pad_mask, None, )
    lin = self.lin
    output = (lin).forward(x2, )
    return torch.div(output, alpha)
class JitPitchPredictor(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  device : Device
  pitch_sil_pred : bool
  pitch_emb_type : str
  speaker_emb : str
  len_reg : __torch__.tacotron2.forward_layers.LengthRegulator
  pitch_pred : __torch__.jit_forward_model.TransformerSeriesPredictor
  pitch_proj : __torch__.torch.nn.modules.conv.___torch_mangle_70.Conv1d
  def forward(self: __torch__.jit_forward_model.JitPitchPredictor,
    text: Tensor,
    speaker_ids: Tensor,
    orig_mask: Optional[Tensor]=None,
    alpha: float=1.) -> Tensor:
    pitch_pred = self.pitch_pred
    pitch_hat = (pitch_pred).forward(text, speaker_ids, orig_mask, alpha, )
    return torch.transpose(pitch_hat, 1, 2)
