class JitGenerator(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  mixed_freq : bool
  super_resolution : bool
  num_kernels : int
  num_upsamples : int
  multiband : bool
  postprocess : int
  resample : int
  stride_d : int
  stride : int
  LRELU_SLOPE : float
  sp_embedding : int
  pqmf_layer : __torch__.vocoder.hifigan.pqmf.PQMF
  conv_pre : __torch__.torch.nn.modules.container.___torch_mangle_8.ModuleList
  ups : __torch__.torch.nn.modules.container.___torch_mangle_11.ModuleList
  ups_u : __torch__.torch.nn.modules.container.___torch_mangle_13.ModuleList
  resblocks : __torch__.torch.nn.modules.container.___torch_mangle_49.ModuleList
  resblocks_u : __torch__.torch.nn.modules.container.___torch_mangle_50.ModuleList
  conv_post : __torch__.torch.nn.modules.conv.___torch_mangle_51.Conv1d
  conv_post_u : __torch__.torch.nn.modules.conv.___torch_mangle_51.Conv1d
  ups_8 : __torch__.torch.nn.modules.container.___torch_mangle_52.ModuleList
  resblocks_8 : __torch__.torch.nn.modules.container.___torch_mangle_53.ModuleList
  def forward(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor,
    sample_rate: int) -> Optional[Tensor]:
    _0 = torch.__contains__([32000, 48000], sample_rate)
    if _0:
      _1 : Optional[Tensor] = (self)._forward_u(x, )
    else:
      if torch.eq(sample_rate, 24000):
        _2 : Optional[Tensor] = (self)._forward_24(x, )
      else:
        if torch.eq(sample_rate, 8000):
          _3 : Optional[Tensor] = (self)._forward_8(x, )
        else:
          _3 = None
        _2 = _3
      _1 = _2
    return _1
  def _forward_u(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    _4 = __torch__.torch.nn.functional.leaky_relu
    conv_pre = self.conv_pre
    _1 = getattr(conv_pre, "1")
    x0 = (_1).forward(x, )
    ups_u = self.ups_u
    _0 = getattr(ups_u, "0")
    _10 = getattr(ups_u, "1")
    _2 = getattr(ups_u, "2")
    _3 = getattr(ups_u, "3")
    LRELU_SLOPE = self.LRELU_SLOPE
    x1 = _4(x0, LRELU_SLOPE, False, )
    x2 = (_0).forward(x1, None, )
    resblocks_u = self.resblocks_u
    _00 = getattr(resblocks_u, "0")
    _11 = getattr(resblocks_u, "1")
    _20 = getattr(resblocks_u, "2")
    _30 = getattr(resblocks_u, "3")
    _40 = getattr(resblocks_u, "4")
    _5 = getattr(resblocks_u, "5")
    _6 = getattr(resblocks_u, "6")
    _7 = getattr(resblocks_u, "7")
    _8 = getattr(resblocks_u, "8")
    _9 = getattr(resblocks_u, "9")
    _100 = getattr(resblocks_u, "10")
    _110 = getattr(resblocks_u, "11")
    num_kernels = self.num_kernels
    _12 = torch.le(torch.mul(0, num_kernels), 0)
    if _12:
      num_kernels0 = self.num_kernels
      _14 = torch.lt(0, torch.mul(1, num_kernels0))
      _13 = _14
    else:
      _13 = False
    if _13:
      num_kernels1 = self.num_kernels
      _15 = torch.eq(torch.mul(0, num_kernels1), 0)
      if _15:
        xs0 = (_00).forward(x2, )
      else:
        xs1 = torch.add_(x2, (_00).forward(x2, ))
        xs0 = xs1
      xs = xs0
    else:
      xs = x2
    num_kernels2 = self.num_kernels
    _16 = torch.le(torch.mul(0, num_kernels2), 1)
    if _16:
      num_kernels3 = self.num_kernels
      _18 = torch.lt(1, torch.mul(1, num_kernels3))
      _17 = _18
    else:
      _17 = False
    if _17:
      num_kernels4 = self.num_kernels
      _19 = torch.eq(torch.mul(0, num_kernels4), 1)
      if _19:
        xs3 = (_11).forward(x2, )
      else:
        xs4 = torch.add_(xs, (_11).forward(x2, ))
        xs3 = xs4
      xs2 = xs3
    else:
      xs2 = xs
    num_kernels5 = self.num_kernels
    _21 = torch.le(torch.mul(0, num_kernels5), 2)
    if _21:
      num_kernels6 = self.num_kernels
      _23 = torch.lt(2, torch.mul(1, num_kernels6))
      _22 = _23
    else:
      _22 = False
    if _22:
      num_kernels7 = self.num_kernels
      _24 = torch.eq(torch.mul(0, num_kernels7), 2)
      if _24:
        xs6 = (_20).forward(x2, )
      else:
        xs7 = torch.add_(xs2, (_20).forward(x2, ))
        xs6 = xs7
      xs5 = xs6
    else:
      xs5 = xs2
    num_kernels8 = self.num_kernels
    _25 = torch.le(torch.mul(0, num_kernels8), 3)
    if _25:
      num_kernels9 = self.num_kernels
      _27 = torch.lt(3, torch.mul(1, num_kernels9))
      _26 = _27
    else:
      _26 = False
    if _26:
      num_kernels10 = self.num_kernels
      _28 = torch.eq(torch.mul(0, num_kernels10), 3)
      if _28:
        xs9 = (_30).forward(x2, )
      else:
        xs10 = torch.add_(xs5, (_30).forward(x2, ))
        xs9 = xs10
      xs8 = xs9
    else:
      xs8 = xs5
    num_kernels11 = self.num_kernels
    _29 = torch.le(torch.mul(0, num_kernels11), 4)
    if _29:
      num_kernels12 = self.num_kernels
      _32 = torch.lt(4, torch.mul(1, num_kernels12))
      _31 = _32
    else:
      _31 = False
    if _31:
      num_kernels13 = self.num_kernels
      _33 = torch.eq(torch.mul(0, num_kernels13), 4)
      if _33:
        xs12 = (_40).forward(x2, )
      else:
        xs13 = torch.add_(xs8, (_40).forward(x2, ))
        xs12 = xs13
      xs11 = xs12
    else:
      xs11 = xs8
    num_kernels14 = self.num_kernels
    _34 = torch.le(torch.mul(0, num_kernels14), 5)
    if _34:
      num_kernels15 = self.num_kernels
      _36 = torch.lt(5, torch.mul(1, num_kernels15))
      _35 = _36
    else:
      _35 = False
    if _35:
      num_kernels16 = self.num_kernels
      _37 = torch.eq(torch.mul(0, num_kernels16), 5)
      if _37:
        xs15 = (_5).forward(x2, )
      else:
        xs16 = torch.add_(xs11, (_5).forward(x2, ))
        xs15 = xs16
      xs14 = xs15
    else:
      xs14 = xs11
    num_kernels17 = self.num_kernels
    _38 = torch.le(torch.mul(0, num_kernels17), 6)
    if _38:
      num_kernels18 = self.num_kernels
      _41 = torch.lt(6, torch.mul(1, num_kernels18))
      _39 = _41
    else:
      _39 = False
    if _39:
      num_kernels19 = self.num_kernels
      _42 = torch.eq(torch.mul(0, num_kernels19), 6)
      if _42:
        xs18 = (_6).forward(x2, )
      else:
        xs19 = torch.add_(xs14, (_6).forward(x2, ))
        xs18 = xs19
      xs17 = xs18
    else:
      xs17 = xs14
    num_kernels20 = self.num_kernels
    _43 = torch.le(torch.mul(0, num_kernels20), 7)
    if _43:
      num_kernels21 = self.num_kernels
      _45 = torch.lt(7, torch.mul(1, num_kernels21))
      _44 = _45
    else:
      _44 = False
    if _44:
      num_kernels22 = self.num_kernels
      _46 = torch.eq(torch.mul(0, num_kernels22), 7)
      if _46:
        xs21 = (_7).forward(x2, )
      else:
        xs22 = torch.add_(xs17, (_7).forward(x2, ))
        xs21 = xs22
      xs20 = xs21
    else:
      xs20 = xs17
    num_kernels23 = self.num_kernels
    _47 = torch.le(torch.mul(0, num_kernels23), 8)
    if _47:
      num_kernels24 = self.num_kernels
      _49 = torch.lt(8, torch.mul(1, num_kernels24))
      _48 = _49
    else:
      _48 = False
    if _48:
      num_kernels25 = self.num_kernels
      _50 = torch.eq(torch.mul(0, num_kernels25), 8)
      if _50:
        xs24 = (_8).forward(x2, )
      else:
        xs25 = torch.add_(xs20, (_8).forward(x2, ))
        xs24 = xs25
      xs23 = xs24
    else:
      xs23 = xs20
    num_kernels26 = self.num_kernels
    _51 = torch.le(torch.mul(0, num_kernels26), 9)
    if _51:
      num_kernels27 = self.num_kernels
      _53 = torch.lt(9, torch.mul(1, num_kernels27))
      _52 = _53
    else:
      _52 = False
    if _52:
      num_kernels28 = self.num_kernels
      _54 = torch.eq(torch.mul(0, num_kernels28), 9)
      if _54:
        xs27 = (_9).forward(x2, )
      else:
        xs28 = torch.add_(xs23, (_9).forward(x2, ))
        xs27 = xs28
      xs26 = xs27
    else:
      xs26 = xs23
    num_kernels29 = self.num_kernels
    _55 = torch.le(torch.mul(0, num_kernels29), 10)
    if _55:
      num_kernels30 = self.num_kernels
      _57 = torch.lt(10, torch.mul(1, num_kernels30))
      _56 = _57
    else:
      _56 = False
    if _56:
      num_kernels31 = self.num_kernels
      _58 = torch.eq(torch.mul(0, num_kernels31), 10)
      if _58:
        xs30 = (_100).forward(x2, )
      else:
        xs31 = torch.add_(xs26, (_100).forward(x2, ))
        xs30 = xs31
      xs29 = xs30
    else:
      xs29 = xs26
    num_kernels32 = self.num_kernels
    _59 = torch.le(torch.mul(0, num_kernels32), 11)
    if _59:
      num_kernels33 = self.num_kernels
      _61 = torch.lt(11, torch.mul(1, num_kernels33))
      _60 = _61
    else:
      _60 = False
    if _60:
      num_kernels34 = self.num_kernels
      _62 = torch.eq(torch.mul(0, num_kernels34), 11)
      if _62:
        xs33 = (_110).forward(x2, )
      else:
        xs34 = torch.add_(xs29, (_110).forward(x2, ))
        xs33 = xs34
      xs32 = xs33
    else:
      xs32 = xs29
    num_kernels35 = self.num_kernels
    x3 = torch.div(xs32, num_kernels35)
    LRELU_SLOPE0 = self.LRELU_SLOPE
    x4 = _4(x3, LRELU_SLOPE0, False, )
    x5 = (_10).forward(x4, None, )
    resblocks_u0 = self.resblocks_u
    _056 = getattr(resblocks_u0, "0")
    _163 = getattr(resblocks_u0, "1")
    _262 = getattr(resblocks_u0, "2")
    _362 = getattr(resblocks_u0, "3")
    _461 = getattr(resblocks_u0, "4")
    _561 = getattr(resblocks_u0, "5")
    _660 = getattr(resblocks_u0, "6")
    _760 = getattr(resblocks_u0, "7")
    _859 = getattr(resblocks_u0, "8")
    _959 = getattr(resblocks_u0, "9")
    _1058 = getattr(resblocks_u0, "10")
    _1158 = getattr(resblocks_u0, "11")
    num_kernels36 = self.num_kernels
    _63 = torch.le(torch.mul(1, num_kernels36), 0)
    if _63:
      num_kernels37 = self.num_kernels
      _65 = torch.lt(0, torch.mul(2, num_kernels37))
      _64 = _65
    else:
      _64 = False
    if _64:
      num_kernels38 = self.num_kernels
      _66 = torch.eq(torch.mul(1, num_kernels38), 0)
      if _66:
        xs36 = (_056).forward(x5, )
      else:
        xs37 = torch.add_(x5, (_056).forward(x5, ))
        xs36 = xs37
      xs35 = xs36
    else:
      xs35 = x5
    num_kernels39 = self.num_kernels
    _67 = torch.le(torch.mul(1, num_kernels39), 1)
    if _67:
      num_kernels40 = self.num_kernels
      _69 = torch.lt(1, torch.mul(2, num_kernels40))
      _68 = _69
    else:
      _68 = False
    if _68:
      num_kernels41 = self.num_kernels
      _70 = torch.eq(torch.mul(1, num_kernels41), 1)
      if _70:
        xs39 = (_163).forward(x5, )
      else:
        xs40 = torch.add_(xs35, (_163).forward(x5, ))
        xs39 = xs40
      xs38 = xs39
    else:
      xs38 = xs35
    num_kernels42 = self.num_kernels
    _71 = torch.le(torch.mul(1, num_kernels42), 2)
    if _71:
      num_kernels43 = self.num_kernels
      _73 = torch.lt(2, torch.mul(2, num_kernels43))
      _72 = _73
    else:
      _72 = False
    if _72:
      num_kernels44 = self.num_kernels
      _74 = torch.eq(torch.mul(1, num_kernels44), 2)
      if _74:
        xs42 = (_262).forward(x5, )
      else:
        xs43 = torch.add_(xs38, (_262).forward(x5, ))
        xs42 = xs43
      xs41 = xs42
    else:
      xs41 = xs38
    num_kernels45 = self.num_kernels
    _75 = torch.le(torch.mul(1, num_kernels45), 3)
    if _75:
      num_kernels46 = self.num_kernels
      _77 = torch.lt(3, torch.mul(2, num_kernels46))
      _76 = _77
    else:
      _76 = False
    if _76:
      num_kernels47 = self.num_kernels
      _78 = torch.eq(torch.mul(1, num_kernels47), 3)
      if _78:
        xs45 = (_362).forward(x5, )
      else:
        xs46 = torch.add_(xs41, (_362).forward(x5, ))
        xs45 = xs46
      xs44 = xs45
    else:
      xs44 = xs41
    num_kernels48 = self.num_kernels
    _79 = torch.le(torch.mul(1, num_kernels48), 4)
    if _79:
      num_kernels49 = self.num_kernels
      _81 = torch.lt(4, torch.mul(2, num_kernels49))
      _80 = _81
    else:
      _80 = False
    if _80:
      num_kernels50 = self.num_kernels
      _82 = torch.eq(torch.mul(1, num_kernels50), 4)
      if _82:
        xs48 = (_461).forward(x5, )
      else:
        xs49 = torch.add_(xs44, (_461).forward(x5, ))
        xs48 = xs49
      xs47 = xs48
    else:
      xs47 = xs44
    num_kernels51 = self.num_kernels
    _83 = torch.le(torch.mul(1, num_kernels51), 5)
    if _83:
      num_kernels52 = self.num_kernels
      _85 = torch.lt(5, torch.mul(2, num_kernels52))
      _84 = _85
    else:
      _84 = False
    if _84:
      num_kernels53 = self.num_kernels
      _86 = torch.eq(torch.mul(1, num_kernels53), 5)
      if _86:
        xs51 = (_561).forward(x5, )
      else:
        xs52 = torch.add_(xs47, (_561).forward(x5, ))
        xs51 = xs52
      xs50 = xs51
    else:
      xs50 = xs47
    num_kernels54 = self.num_kernels
    _87 = torch.le(torch.mul(1, num_kernels54), 6)
    if _87:
      num_kernels55 = self.num_kernels
      _89 = torch.lt(6, torch.mul(2, num_kernels55))
      _88 = _89
    else:
      _88 = False
    if _88:
      num_kernels56 = self.num_kernels
      _90 = torch.eq(torch.mul(1, num_kernels56), 6)
      if _90:
        xs54 = (_660).forward(x5, )
      else:
        xs55 = torch.add_(xs50, (_660).forward(x5, ))
        xs54 = xs55
      xs53 = xs54
    else:
      xs53 = xs50
    num_kernels57 = self.num_kernels
    _91 = torch.le(torch.mul(1, num_kernels57), 7)
    if _91:
      num_kernels58 = self.num_kernels
      _93 = torch.lt(7, torch.mul(2, num_kernels58))
      _92 = _93
    else:
      _92 = False
    if _92:
      num_kernels59 = self.num_kernels
      _94 = torch.eq(torch.mul(1, num_kernels59), 7)
      if _94:
        xs57 = (_760).forward(x5, )
      else:
        xs58 = torch.add_(xs53, (_760).forward(x5, ))
        xs57 = xs58
      xs56 = xs57
    else:
      xs56 = xs53
    num_kernels60 = self.num_kernels
    _95 = torch.le(torch.mul(1, num_kernels60), 8)
    if _95:
      num_kernels61 = self.num_kernels
      _97 = torch.lt(8, torch.mul(2, num_kernels61))
      _96 = _97
    else:
      _96 = False
    if _96:
      num_kernels62 = self.num_kernels
      _98 = torch.eq(torch.mul(1, num_kernels62), 8)
      if _98:
        xs60 = (_859).forward(x5, )
      else:
        xs61 = torch.add_(xs56, (_859).forward(x5, ))
        xs60 = xs61
      xs59 = xs60
    else:
      xs59 = xs56
    num_kernels63 = self.num_kernels
    _99 = torch.le(torch.mul(1, num_kernels63), 9)
    if _99:
      num_kernels64 = self.num_kernels
      _102 = torch.lt(9, torch.mul(2, num_kernels64))
      _101 = _102
    else:
      _101 = False
    if _101:
      num_kernels65 = self.num_kernels
      _103 = torch.eq(torch.mul(1, num_kernels65), 9)
      if _103:
        xs63 = (_959).forward(x5, )
      else:
        xs64 = torch.add_(xs59, (_959).forward(x5, ))
        xs63 = xs64
      xs62 = xs63
    else:
      xs62 = xs59
    num_kernels66 = self.num_kernels
    _104 = torch.le(torch.mul(1, num_kernels66), 10)
    if _104:
      num_kernels67 = self.num_kernels
      _106 = torch.lt(10, torch.mul(2, num_kernels67))
      _105 = _106
    else:
      _105 = False
    if _105:
      num_kernels68 = self.num_kernels
      _107 = torch.eq(torch.mul(1, num_kernels68), 10)
      if _107:
        xs66 = (_1058).forward(x5, )
      else:
        xs67 = torch.add_(xs62, (_1058).forward(x5, ))
        xs66 = xs67
      xs65 = xs66
    else:
      xs65 = xs62
    num_kernels69 = self.num_kernels
    _108 = torch.le(torch.mul(1, num_kernels69), 11)
    if _108:
      num_kernels70 = self.num_kernels
      _111 = torch.lt(11, torch.mul(2, num_kernels70))
      _109 = _111
    else:
      _109 = False
    if _109:
      num_kernels71 = self.num_kernels
      _112 = torch.eq(torch.mul(1, num_kernels71), 11)
      if _112:
        xs69 = (_1158).forward(x5, )
      else:
        xs70 = torch.add_(xs65, (_1158).forward(x5, ))
        xs69 = xs70
      xs68 = xs69
    else:
      xs68 = xs65
    num_kernels72 = self.num_kernels
    x6 = torch.div(xs68, num_kernels72)
    LRELU_SLOPE1 = self.LRELU_SLOPE
    x7 = _4(x6, LRELU_SLOPE1, False, )
    x8 = (_2).forward(x7, None, )
    resblocks_u1 = self.resblocks_u
    _0106 = getattr(resblocks_u1, "0")
    _1113 = getattr(resblocks_u1, "1")
    _2111 = getattr(resblocks_u1, "2")
    _3110 = getattr(resblocks_u1, "3")
    _4109 = getattr(resblocks_u1, "4")
    _5108 = getattr(resblocks_u1, "5")
    _6107 = getattr(resblocks_u1, "6")
    _7105 = getattr(resblocks_u1, "7")
    _8103 = getattr(resblocks_u1, "8")
    _9101 = getattr(resblocks_u1, "9")
    _1063 = getattr(resblocks_u1, "10")
    _1162 = getattr(resblocks_u1, "11")
    num_kernels73 = self.num_kernels
    _113 = torch.le(torch.mul(2, num_kernels73), 0)
    if _113:
      num_kernels74 = self.num_kernels
      _115 = torch.lt(0, torch.mul(3, num_kernels74))
      _114 = _115
    else:
      _114 = False
    if _114:
      num_kernels75 = self.num_kernels
      _116 = torch.eq(torch.mul(2, num_kernels75), 0)
      if _116:
        xs72 = (_0106).forward(x8, )
      else:
        xs73 = torch.add_(x8, (_0106).forward(x8, ))
        xs72 = xs73
      xs71 = xs72
    else:
      xs71 = x8
    num_kernels76 = self.num_kernels
    _117 = torch.le(torch.mul(2, num_kernels76), 1)
    if _117:
      num_kernels77 = self.num_kernels
      _119 = torch.lt(1, torch.mul(3, num_kernels77))
      _118 = _119
    else:
      _118 = False
    if _118:
      num_kernels78 = self.num_kernels
      _120 = torch.eq(torch.mul(2, num_kernels78), 1)
      if _120:
        xs75 = (_1113).forward(x8, )
      else:
        xs76 = torch.add_(xs71, (_1113).forward(x8, ))
        xs75 = xs76
      xs74 = xs75
    else:
      xs74 = xs71
    num_kernels79 = self.num_kernels
    _121 = torch.le(torch.mul(2, num_kernels79), 2)
    if _121:
      num_kernels80 = self.num_kernels
      _123 = torch.lt(2, torch.mul(3, num_kernels80))
      _122 = _123
    else:
      _122 = False
    if _122:
      num_kernels81 = self.num_kernels
      _124 = torch.eq(torch.mul(2, num_kernels81), 2)
      if _124:
        xs78 = (_2111).forward(x8, )
      else:
        xs79 = torch.add_(xs74, (_2111).forward(x8, ))
        xs78 = xs79
      xs77 = xs78
    else:
      xs77 = xs74
    num_kernels82 = self.num_kernels
    _125 = torch.le(torch.mul(2, num_kernels82), 3)
    if _125:
      num_kernels83 = self.num_kernels
      _127 = torch.lt(3, torch.mul(3, num_kernels83))
      _126 = _127
    else:
      _126 = False
    if _126:
      num_kernels84 = self.num_kernels
      _128 = torch.eq(torch.mul(2, num_kernels84), 3)
      if _128:
        xs81 = (_3110).forward(x8, )
      else:
        xs82 = torch.add_(xs77, (_3110).forward(x8, ))
        xs81 = xs82
      xs80 = xs81
    else:
      xs80 = xs77
    num_kernels85 = self.num_kernels
    _129 = torch.le(torch.mul(2, num_kernels85), 4)
    if _129:
      num_kernels86 = self.num_kernels
      _131 = torch.lt(4, torch.mul(3, num_kernels86))
      _130 = _131
    else:
      _130 = False
    if _130:
      num_kernels87 = self.num_kernels
      _132 = torch.eq(torch.mul(2, num_kernels87), 4)
      if _132:
        xs84 = (_4109).forward(x8, )
      else:
        xs85 = torch.add_(xs80, (_4109).forward(x8, ))
        xs84 = xs85
      xs83 = xs84
    else:
      xs83 = xs80
    num_kernels88 = self.num_kernels
    _133 = torch.le(torch.mul(2, num_kernels88), 5)
    if _133:
      num_kernels89 = self.num_kernels
      _135 = torch.lt(5, torch.mul(3, num_kernels89))
      _134 = _135
    else:
      _134 = False
    if _134:
      num_kernels90 = self.num_kernels
      _136 = torch.eq(torch.mul(2, num_kernels90), 5)
      if _136:
        xs87 = (_5108).forward(x8, )
      else:
        xs88 = torch.add_(xs83, (_5108).forward(x8, ))
        xs87 = xs88
      xs86 = xs87
    else:
      xs86 = xs83
    num_kernels91 = self.num_kernels
    _137 = torch.le(torch.mul(2, num_kernels91), 6)
    if _137:
      num_kernels92 = self.num_kernels
      _139 = torch.lt(6, torch.mul(3, num_kernels92))
      _138 = _139
    else:
      _138 = False
    if _138:
      num_kernels93 = self.num_kernels
      _140 = torch.eq(torch.mul(2, num_kernels93), 6)
      if _140:
        xs90 = (_6107).forward(x8, )
      else:
        xs91 = torch.add_(xs86, (_6107).forward(x8, ))
        xs90 = xs91
      xs89 = xs90
    else:
      xs89 = xs86
    num_kernels94 = self.num_kernels
    _141 = torch.le(torch.mul(2, num_kernels94), 7)
    if _141:
      num_kernels95 = self.num_kernels
      _143 = torch.lt(7, torch.mul(3, num_kernels95))
      _142 = _143
    else:
      _142 = False
    if _142:
      num_kernels96 = self.num_kernels
      _144 = torch.eq(torch.mul(2, num_kernels96), 7)
      if _144:
        xs93 = (_7105).forward(x8, )
      else:
        xs94 = torch.add_(xs89, (_7105).forward(x8, ))
        xs93 = xs94
      xs92 = xs93
    else:
      xs92 = xs89
    num_kernels97 = self.num_kernels
    _145 = torch.le(torch.mul(2, num_kernels97), 8)
    if _145:
      num_kernels98 = self.num_kernels
      _147 = torch.lt(8, torch.mul(3, num_kernels98))
      _146 = _147
    else:
      _146 = False
    if _146:
      num_kernels99 = self.num_kernels
      _148 = torch.eq(torch.mul(2, num_kernels99), 8)
      if _148:
        xs96 = (_8103).forward(x8, )
      else:
        xs97 = torch.add_(xs92, (_8103).forward(x8, ))
        xs96 = xs97
      xs95 = xs96
    else:
      xs95 = xs92
    num_kernels100 = self.num_kernels
    _149 = torch.le(torch.mul(2, num_kernels100), 9)
    if _149:
      num_kernels101 = self.num_kernels
      _151 = torch.lt(9, torch.mul(3, num_kernels101))
      _150 = _151
    else:
      _150 = False
    if _150:
      num_kernels102 = self.num_kernels
      _152 = torch.eq(torch.mul(2, num_kernels102), 9)
      if _152:
        xs99 = (_9101).forward(x8, )
      else:
        xs100 = torch.add_(xs95, (_9101).forward(x8, ))
        xs99 = xs100
      xs98 = xs99
    else:
      xs98 = xs95
    num_kernels103 = self.num_kernels
    _153 = torch.le(torch.mul(2, num_kernels103), 10)
    if _153:
      num_kernels104 = self.num_kernels
      _155 = torch.lt(10, torch.mul(3, num_kernels104))
      _154 = _155
    else:
      _154 = False
    if _154:
      num_kernels105 = self.num_kernels
      _156 = torch.eq(torch.mul(2, num_kernels105), 10)
      if _156:
        xs102 = (_1063).forward(x8, )
      else:
        xs103 = torch.add_(xs98, (_1063).forward(x8, ))
        xs102 = xs103
      xs101 = xs102
    else:
      xs101 = xs98
    num_kernels106 = self.num_kernels
    _157 = torch.le(torch.mul(2, num_kernels106), 11)
    if _157:
      num_kernels107 = self.num_kernels
      _159 = torch.lt(11, torch.mul(3, num_kernels107))
      _158 = _159
    else:
      _158 = False
    if _158:
      num_kernels108 = self.num_kernels
      _160 = torch.eq(torch.mul(2, num_kernels108), 11)
      if _160:
        xs105 = (_1162).forward(x8, )
      else:
        xs106 = torch.add_(xs101, (_1162).forward(x8, ))
        xs105 = xs106
      xs104 = xs105
    else:
      xs104 = xs101
    num_kernels109 = self.num_kernels
    x9 = torch.div(xs104, num_kernels109)
    LRELU_SLOPE2 = self.LRELU_SLOPE
    x10 = _4(x9, LRELU_SLOPE2, False, )
    x11 = (_3).forward(x10, None, )
    resblocks_u2 = self.resblocks_u
    _0155 = getattr(resblocks_u2, "0")
    _1161 = getattr(resblocks_u2, "1")
    _2159 = getattr(resblocks_u2, "2")
    _3158 = getattr(resblocks_u2, "3")
    _4156 = getattr(resblocks_u2, "4")
    _5153 = getattr(resblocks_u2, "5")
    _6150 = getattr(resblocks_u2, "6")
    _7110 = getattr(resblocks_u2, "7")
    _8107 = getattr(resblocks_u2, "8")
    _9102 = getattr(resblocks_u2, "9")
    _1064 = getattr(resblocks_u2, "10")
    _1163 = getattr(resblocks_u2, "11")
    num_kernels110 = self.num_kernels
    _161 = torch.le(torch.mul(3, num_kernels110), 0)
    if _161:
      num_kernels111 = self.num_kernels
      _164 = torch.lt(0, torch.mul(4, num_kernels111))
      _162 = _164
    else:
      _162 = False
    if _162:
      num_kernels112 = self.num_kernels
      _165 = torch.eq(torch.mul(3, num_kernels112), 0)
      if _165:
        xs108 = (_0155).forward(x11, )
      else:
        xs109 = torch.add_(x11, (_0155).forward(x11, ))
        xs108 = xs109
      xs107 = xs108
    else:
      xs107 = x11
    num_kernels113 = self.num_kernels
    _166 = torch.le(torch.mul(3, num_kernels113), 1)
    if _166:
      num_kernels114 = self.num_kernels
      _168 = torch.lt(1, torch.mul(4, num_kernels114))
      _167 = _168
    else:
      _167 = False
    if _167:
      num_kernels115 = self.num_kernels
      _169 = torch.eq(torch.mul(3, num_kernels115), 1)
      if _169:
        xs111 = (_1161).forward(x11, )
      else:
        xs112 = torch.add_(xs107, (_1161).forward(x11, ))
        xs111 = xs112
      xs110 = xs111
    else:
      xs110 = xs107
    num_kernels116 = self.num_kernels
    _170 = torch.le(torch.mul(3, num_kernels116), 2)
    if _170:
      num_kernels117 = self.num_kernels
      _172 = torch.lt(2, torch.mul(4, num_kernels117))
      _171 = _172
    else:
      _171 = False
    if _171:
      num_kernels118 = self.num_kernels
      _173 = torch.eq(torch.mul(3, num_kernels118), 2)
      if _173:
        xs114 = (_2159).forward(x11, )
      else:
        xs115 = torch.add_(xs110, (_2159).forward(x11, ))
        xs114 = xs115
      xs113 = xs114
    else:
      xs113 = xs110
    num_kernels119 = self.num_kernels
    _174 = torch.le(torch.mul(3, num_kernels119), 3)
    if _174:
      num_kernels120 = self.num_kernels
      _176 = torch.lt(3, torch.mul(4, num_kernels120))
      _175 = _176
    else:
      _175 = False
    if _175:
      num_kernels121 = self.num_kernels
      _177 = torch.eq(torch.mul(3, num_kernels121), 3)
      if _177:
        xs117 = (_3158).forward(x11, )
      else:
        xs118 = torch.add_(xs113, (_3158).forward(x11, ))
        xs117 = xs118
      xs116 = xs117
    else:
      xs116 = xs113
    num_kernels122 = self.num_kernels
    _178 = torch.le(torch.mul(3, num_kernels122), 4)
    if _178:
      num_kernels123 = self.num_kernels
      _180 = torch.lt(4, torch.mul(4, num_kernels123))
      _179 = _180
    else:
      _179 = False
    if _179:
      num_kernels124 = self.num_kernels
      _181 = torch.eq(torch.mul(3, num_kernels124), 4)
      if _181:
        xs120 = (_4156).forward(x11, )
      else:
        xs121 = torch.add_(xs116, (_4156).forward(x11, ))
        xs120 = xs121
      xs119 = xs120
    else:
      xs119 = xs116
    num_kernels125 = self.num_kernels
    _182 = torch.le(torch.mul(3, num_kernels125), 5)
    if _182:
      num_kernels126 = self.num_kernels
      _184 = torch.lt(5, torch.mul(4, num_kernels126))
      _183 = _184
    else:
      _183 = False
    if _183:
      num_kernels127 = self.num_kernels
      _185 = torch.eq(torch.mul(3, num_kernels127), 5)
      if _185:
        xs123 = (_5153).forward(x11, )
      else:
        xs124 = torch.add_(xs119, (_5153).forward(x11, ))
        xs123 = xs124
      xs122 = xs123
    else:
      xs122 = xs119
    num_kernels128 = self.num_kernels
    _186 = torch.le(torch.mul(3, num_kernels128), 6)
    if _186:
      num_kernels129 = self.num_kernels
      _188 = torch.lt(6, torch.mul(4, num_kernels129))
      _187 = _188
    else:
      _187 = False
    if _187:
      num_kernels130 = self.num_kernels
      _189 = torch.eq(torch.mul(3, num_kernels130), 6)
      if _189:
        xs126 = (_6150).forward(x11, )
      else:
        xs127 = torch.add_(xs122, (_6150).forward(x11, ))
        xs126 = xs127
      xs125 = xs126
    else:
      xs125 = xs122
    num_kernels131 = self.num_kernels
    _190 = torch.le(torch.mul(3, num_kernels131), 7)
    if _190:
      num_kernels132 = self.num_kernels
      _192 = torch.lt(7, torch.mul(4, num_kernels132))
      _191 = _192
    else:
      _191 = False
    if _191:
      num_kernels133 = self.num_kernels
      _193 = torch.eq(torch.mul(3, num_kernels133), 7)
      if _193:
        xs129 = (_7110).forward(x11, )
      else:
        xs130 = torch.add_(xs125, (_7110).forward(x11, ))
        xs129 = xs130
      xs128 = xs129
    else:
      xs128 = xs125
    num_kernels134 = self.num_kernels
    _194 = torch.le(torch.mul(3, num_kernels134), 8)
    if _194:
      num_kernels135 = self.num_kernels
      _196 = torch.lt(8, torch.mul(4, num_kernels135))
      _195 = _196
    else:
      _195 = False
    if _195:
      num_kernels136 = self.num_kernels
      _197 = torch.eq(torch.mul(3, num_kernels136), 8)
      if _197:
        xs132 = (_8107).forward(x11, )
      else:
        xs133 = torch.add_(xs128, (_8107).forward(x11, ))
        xs132 = xs133
      xs131 = xs132
    else:
      xs131 = xs128
    num_kernels137 = self.num_kernels
    _198 = torch.le(torch.mul(3, num_kernels137), 9)
    if _198:
      num_kernels138 = self.num_kernels
      _200 = torch.lt(9, torch.mul(4, num_kernels138))
      _199 = _200
    else:
      _199 = False
    if _199:
      num_kernels139 = self.num_kernels
      _201 = torch.eq(torch.mul(3, num_kernels139), 9)
      if _201:
        xs135 = (_9102).forward(x11, )
      else:
        xs136 = torch.add_(xs131, (_9102).forward(x11, ))
        xs135 = xs136
      xs134 = xs135
    else:
      xs134 = xs131
    num_kernels140 = self.num_kernels
    _202 = torch.le(torch.mul(3, num_kernels140), 10)
    if _202:
      num_kernels141 = self.num_kernels
      _204 = torch.lt(10, torch.mul(4, num_kernels141))
      _203 = _204
    else:
      _203 = False
    if _203:
      num_kernels142 = self.num_kernels
      _205 = torch.eq(torch.mul(3, num_kernels142), 10)
      if _205:
        xs138 = (_1064).forward(x11, )
      else:
        xs139 = torch.add_(xs134, (_1064).forward(x11, ))
        xs138 = xs139
      xs137 = xs138
    else:
      xs137 = xs134
    num_kernels143 = self.num_kernels
    _206 = torch.le(torch.mul(3, num_kernels143), 11)
    if _206:
      num_kernels144 = self.num_kernels
      _208 = torch.lt(11, torch.mul(4, num_kernels144))
      _207 = _208
    else:
      _207 = False
    if _207:
      num_kernels145 = self.num_kernels
      _209 = torch.eq(torch.mul(3, num_kernels145), 11)
      if _209:
        xs141 = (_1163).forward(x11, )
      else:
        xs142 = torch.add_(xs137, (_1163).forward(x11, ))
        xs141 = xs142
      xs140 = xs141
    else:
      xs140 = xs137
    num_kernels146 = self.num_kernels
    x12 = torch.div(xs140, num_kernels146)
    x13 = _4(x12, 0.01, False, )
    conv_post_u = self.conv_post_u
    x14 = (conv_post_u).forward(x13, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _210 = torch.tanh(x14)
    else:
      _210 = (self).pqmf_synthesis(x14, )
    return _210
  def pqmf_synthesis(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    pqmf_layer = self.pqmf_layer
    resample = self.resample
    _198 = (pqmf_layer).synthesis(x, resample, )
    return _198
  def _forward_24(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    _199 = __torch__.torch.nn.functional.leaky_relu
    conv_pre = self.conv_pre
    _1 = getattr(conv_pre, "1")
    x15 = (_1).forward(x, )
    ups = self.ups
    _0 = getattr(ups, "0")
    _1211 = getattr(ups, "1")
    _2 = getattr(ups, "2")
    LRELU_SLOPE = self.LRELU_SLOPE
    x16 = _199(x15, LRELU_SLOPE, False, )
    x17 = (_0).forward(x16, None, )
    resblocks = self.resblocks
    _0207 = getattr(resblocks, "0")
    _1212 = getattr(resblocks, "1")
    _2210 = getattr(resblocks, "2")
    _3 = getattr(resblocks, "3")
    _4 = getattr(resblocks, "4")
    _5 = getattr(resblocks, "5")
    _6 = getattr(resblocks, "6")
    _7 = getattr(resblocks, "7")
    _8 = getattr(resblocks, "8")
    num_kernels = self.num_kernels
    _200 = torch.le(torch.mul(0, num_kernels), 0)
    if _200:
      num_kernels147 = self.num_kernels
      _202 = torch.lt(0, torch.mul(1, num_kernels147))
      _201 = _202
    else:
      _201 = False
    if _201:
      num_kernels148 = self.num_kernels
      _203 = torch.eq(torch.mul(0, num_kernels148), 0)
      if _203:
        xs143 = (_0207).forward(x17, )
      else:
        xs144 = torch.add_(x17, (_0207).forward(x17, ))
        xs143 = xs144
      xs = xs143
    else:
      xs = x17
    num_kernels149 = self.num_kernels
    _204 = torch.le(torch.mul(0, num_kernels149), 1)
    if _204:
      num_kernels150 = self.num_kernels
      _206 = torch.lt(1, torch.mul(1, num_kernels150))
      _205 = _206
    else:
      _205 = False
    if _205:
      num_kernels151 = self.num_kernels
      _207 = torch.eq(torch.mul(0, num_kernels151), 1)
      if _207:
        xs146 = (_1212).forward(x17, )
      else:
        xs147 = torch.add_(xs, (_1212).forward(x17, ))
        xs146 = xs147
      xs145 = xs146
    else:
      xs145 = xs
    num_kernels152 = self.num_kernels
    _208 = torch.le(torch.mul(0, num_kernels152), 2)
    if _208:
      num_kernels153 = self.num_kernels
      _210 = torch.lt(2, torch.mul(1, num_kernels153))
      _209 = _210
    else:
      _209 = False
    if _209:
      num_kernels154 = self.num_kernels
      _211 = torch.eq(torch.mul(0, num_kernels154), 2)
      if _211:
        xs149 = (_2210).forward(x17, )
      else:
        xs150 = torch.add_(xs145, (_2210).forward(x17, ))
        xs149 = xs150
      xs148 = xs149
    else:
      xs148 = xs145
    num_kernels155 = self.num_kernels
    _212 = torch.le(torch.mul(0, num_kernels155), 3)
    if _212:
      num_kernels156 = self.num_kernels
      _214 = torch.lt(3, torch.mul(1, num_kernels156))
      _213 = _214
    else:
      _213 = False
    if _213:
      num_kernels157 = self.num_kernels
      _215 = torch.eq(torch.mul(0, num_kernels157), 3)
      if _215:
        xs152 = (_3).forward(x17, )
      else:
        xs153 = torch.add_(xs148, (_3).forward(x17, ))
        xs152 = xs153
      xs151 = xs152
    else:
      xs151 = xs148
    num_kernels158 = self.num_kernels
    _216 = torch.le(torch.mul(0, num_kernels158), 4)
    if _216:
      num_kernels159 = self.num_kernels
      _218 = torch.lt(4, torch.mul(1, num_kernels159))
      _217 = _218
    else:
      _217 = False
    if _217:
      num_kernels160 = self.num_kernels
      _219 = torch.eq(torch.mul(0, num_kernels160), 4)
      if _219:
        xs155 = (_4).forward(x17, )
      else:
        xs156 = torch.add_(xs151, (_4).forward(x17, ))
        xs155 = xs156
      xs154 = xs155
    else:
      xs154 = xs151
    num_kernels161 = self.num_kernels
    _220 = torch.le(torch.mul(0, num_kernels161), 5)
    if _220:
      num_kernels162 = self.num_kernels
      _222 = torch.lt(5, torch.mul(1, num_kernels162))
      _221 = _222
    else:
      _221 = False
    if _221:
      num_kernels163 = self.num_kernels
      _223 = torch.eq(torch.mul(0, num_kernels163), 5)
      if _223:
        xs158 = (_5).forward(x17, )
      else:
        xs159 = torch.add_(xs154, (_5).forward(x17, ))
        xs158 = xs159
      xs157 = xs158
    else:
      xs157 = xs154
    num_kernels164 = self.num_kernels
    _224 = torch.le(torch.mul(0, num_kernels164), 6)
    if _224:
      num_kernels165 = self.num_kernels
      _226 = torch.lt(6, torch.mul(1, num_kernels165))
      _225 = _226
    else:
      _225 = False
    if _225:
      num_kernels166 = self.num_kernels
      _227 = torch.eq(torch.mul(0, num_kernels166), 6)
      if _227:
        xs161 = (_6).forward(x17, )
      else:
        xs162 = torch.add_(xs157, (_6).forward(x17, ))
        xs161 = xs162
      xs160 = xs161
    else:
      xs160 = xs157
    num_kernels167 = self.num_kernels
    _228 = torch.le(torch.mul(0, num_kernels167), 7)
    if _228:
      num_kernels168 = self.num_kernels
      _230 = torch.lt(7, torch.mul(1, num_kernels168))
      _229 = _230
    else:
      _229 = False
    if _229:
      num_kernels169 = self.num_kernels
      _231 = torch.eq(torch.mul(0, num_kernels169), 7)
      if _231:
        xs164 = (_7).forward(x17, )
      else:
        xs165 = torch.add_(xs160, (_7).forward(x17, ))
        xs164 = xs165
      xs163 = xs164
    else:
      xs163 = xs160
    num_kernels170 = self.num_kernels
    _232 = torch.le(torch.mul(0, num_kernels170), 8)
    if _232:
      num_kernels171 = self.num_kernels
      _234 = torch.lt(8, torch.mul(1, num_kernels171))
      _233 = _234
    else:
      _233 = False
    if _233:
      num_kernels172 = self.num_kernels
      _235 = torch.eq(torch.mul(0, num_kernels172), 8)
      if _235:
        xs167 = (_8).forward(x17, )
      else:
        xs168 = torch.add_(xs163, (_8).forward(x17, ))
        xs167 = xs168
      xs166 = xs167
    else:
      xs166 = xs163
    num_kernels173 = self.num_kernels
    x18 = torch.div(xs166, num_kernels173)
    LRELU_SLOPE3 = self.LRELU_SLOPE
    x19 = _199(x18, LRELU_SLOPE3, False, )
    x20 = (_1211).forward(x19, None, )
    resblocks0 = self.resblocks
    _0208 = getattr(resblocks0, "0")
    _1213 = getattr(resblocks0, "1")
    _2211 = getattr(resblocks0, "2")
    _3206 = getattr(resblocks0, "3")
    _4202 = getattr(resblocks0, "4")
    _5162 = getattr(resblocks0, "5")
    _6154 = getattr(resblocks0, "6")
    _7111 = getattr(resblocks0, "7")
    _8108 = getattr(resblocks0, "8")
    num_kernels174 = self.num_kernels
    _236 = torch.le(torch.mul(1, num_kernels174), 0)
    if _236:
      num_kernels175 = self.num_kernels
      _238 = torch.lt(0, torch.mul(2, num_kernels175))
      _237 = _238
    else:
      _237 = False
    if _237:
      num_kernels176 = self.num_kernels
      _239 = torch.eq(torch.mul(1, num_kernels176), 0)
      if _239:
        xs170 = (_0208).forward(x20, )
      else:
        xs171 = torch.add_(x20, (_0208).forward(x20, ))
        xs170 = xs171
      xs169 = xs170
    else:
      xs169 = x20
    num_kernels177 = self.num_kernels
    _240 = torch.le(torch.mul(1, num_kernels177), 1)
    if _240:
      num_kernels178 = self.num_kernels
      _242 = torch.lt(1, torch.mul(2, num_kernels178))
      _241 = _242
    else:
      _241 = False
    if _241:
      num_kernels179 = self.num_kernels
      _243 = torch.eq(torch.mul(1, num_kernels179), 1)
      if _243:
        xs173 = (_1213).forward(x20, )
      else:
        xs174 = torch.add_(xs169, (_1213).forward(x20, ))
        xs173 = xs174
      xs172 = xs173
    else:
      xs172 = xs169
    num_kernels180 = self.num_kernels
    _244 = torch.le(torch.mul(1, num_kernels180), 2)
    if _244:
      num_kernels181 = self.num_kernels
      _246 = torch.lt(2, torch.mul(2, num_kernels181))
      _245 = _246
    else:
      _245 = False
    if _245:
      num_kernels182 = self.num_kernels
      _247 = torch.eq(torch.mul(1, num_kernels182), 2)
      if _247:
        xs176 = (_2211).forward(x20, )
      else:
        xs177 = torch.add_(xs172, (_2211).forward(x20, ))
        xs176 = xs177
      xs175 = xs176
    else:
      xs175 = xs172
    num_kernels183 = self.num_kernels
    _248 = torch.le(torch.mul(1, num_kernels183), 3)
    if _248:
      num_kernels184 = self.num_kernels
      _250 = torch.lt(3, torch.mul(2, num_kernels184))
      _249 = _250
    else:
      _249 = False
    if _249:
      num_kernels185 = self.num_kernels
      _251 = torch.eq(torch.mul(1, num_kernels185), 3)
      if _251:
        xs179 = (_3206).forward(x20, )
      else:
        xs180 = torch.add_(xs175, (_3206).forward(x20, ))
        xs179 = xs180
      xs178 = xs179
    else:
      xs178 = xs175
    num_kernels186 = self.num_kernels
    _252 = torch.le(torch.mul(1, num_kernels186), 4)
    if _252:
      num_kernels187 = self.num_kernels
      _254 = torch.lt(4, torch.mul(2, num_kernels187))
      _253 = _254
    else:
      _253 = False
    if _253:
      num_kernels188 = self.num_kernels
      _255 = torch.eq(torch.mul(1, num_kernels188), 4)
      if _255:
        xs182 = (_4202).forward(x20, )
      else:
        xs183 = torch.add_(xs178, (_4202).forward(x20, ))
        xs182 = xs183
      xs181 = xs182
    else:
      xs181 = xs178
    num_kernels189 = self.num_kernels
    _256 = torch.le(torch.mul(1, num_kernels189), 5)
    if _256:
      num_kernels190 = self.num_kernels
      _258 = torch.lt(5, torch.mul(2, num_kernels190))
      _257 = _258
    else:
      _257 = False
    if _257:
      num_kernels191 = self.num_kernels
      _259 = torch.eq(torch.mul(1, num_kernels191), 5)
      if _259:
        xs185 = (_5162).forward(x20, )
      else:
        xs186 = torch.add_(xs181, (_5162).forward(x20, ))
        xs185 = xs186
      xs184 = xs185
    else:
      xs184 = xs181
    num_kernels192 = self.num_kernels
    _260 = torch.le(torch.mul(1, num_kernels192), 6)
    if _260:
      num_kernels193 = self.num_kernels
      _262 = torch.lt(6, torch.mul(2, num_kernels193))
      _261 = _262
    else:
      _261 = False
    if _261:
      num_kernels194 = self.num_kernels
      _263 = torch.eq(torch.mul(1, num_kernels194), 6)
      if _263:
        xs188 = (_6154).forward(x20, )
      else:
        xs189 = torch.add_(xs184, (_6154).forward(x20, ))
        xs188 = xs189
      xs187 = xs188
    else:
      xs187 = xs184
    num_kernels195 = self.num_kernels
    _264 = torch.le(torch.mul(1, num_kernels195), 7)
    if _264:
      num_kernels196 = self.num_kernels
      _266 = torch.lt(7, torch.mul(2, num_kernels196))
      _265 = _266
    else:
      _265 = False
    if _265:
      num_kernels197 = self.num_kernels
      _267 = torch.eq(torch.mul(1, num_kernels197), 7)
      if _267:
        xs191 = (_7111).forward(x20, )
      else:
        xs192 = torch.add_(xs187, (_7111).forward(x20, ))
        xs191 = xs192
      xs190 = xs191
    else:
      xs190 = xs187
    num_kernels198 = self.num_kernels
    _268 = torch.le(torch.mul(1, num_kernels198), 8)
    if _268:
      num_kernels199 = self.num_kernels
      _270 = torch.lt(8, torch.mul(2, num_kernels199))
      _269 = _270
    else:
      _269 = False
    if _269:
      num_kernels200 = self.num_kernels
      _271 = torch.eq(torch.mul(1, num_kernels200), 8)
      if _271:
        xs194 = (_8108).forward(x20, )
      else:
        xs195 = torch.add_(xs190, (_8108).forward(x20, ))
        xs194 = xs195
      xs193 = xs194
    else:
      xs193 = xs190
    num_kernels201 = self.num_kernels
    x21 = torch.div(xs193, num_kernels201)
    LRELU_SLOPE4 = self.LRELU_SLOPE
    x22 = _199(x21, LRELU_SLOPE4, False, )
    x23 = (_2).forward(x22, None, )
    resblocks1 = self.resblocks
    _0209 = getattr(resblocks1, "0")
    _1214 = getattr(resblocks1, "1")
    _2212 = getattr(resblocks1, "2")
    _3207 = getattr(resblocks1, "3")
    _4203 = getattr(resblocks1, "4")
    _5163 = getattr(resblocks1, "5")
    _6155 = getattr(resblocks1, "6")
    _7112 = getattr(resblocks1, "7")
    _8109 = getattr(resblocks1, "8")
    num_kernels202 = self.num_kernels
    _272 = torch.le(torch.mul(2, num_kernels202), 0)
    if _272:
      num_kernels203 = self.num_kernels
      _274 = torch.lt(0, torch.mul(3, num_kernels203))
      _273 = _274
    else:
      _273 = False
    if _273:
      num_kernels204 = self.num_kernels
      _275 = torch.eq(torch.mul(2, num_kernels204), 0)
      if _275:
        xs197 = (_0209).forward(x23, )
      else:
        xs198 = torch.add_(x23, (_0209).forward(x23, ))
        xs197 = xs198
      xs196 = xs197
    else:
      xs196 = x23
    num_kernels205 = self.num_kernels
    _276 = torch.le(torch.mul(2, num_kernels205), 1)
    if _276:
      num_kernels206 = self.num_kernels
      _278 = torch.lt(1, torch.mul(3, num_kernels206))
      _277 = _278
    else:
      _277 = False
    if _277:
      num_kernels207 = self.num_kernels
      _279 = torch.eq(torch.mul(2, num_kernels207), 1)
      if _279:
        xs200 = (_1214).forward(x23, )
      else:
        xs201 = torch.add_(xs196, (_1214).forward(x23, ))
        xs200 = xs201
      xs199 = xs200
    else:
      xs199 = xs196
    num_kernels208 = self.num_kernels
    _280 = torch.le(torch.mul(2, num_kernels208), 2)
    if _280:
      num_kernels209 = self.num_kernels
      _282 = torch.lt(2, torch.mul(3, num_kernels209))
      _281 = _282
    else:
      _281 = False
    if _281:
      num_kernels210 = self.num_kernels
      _283 = torch.eq(torch.mul(2, num_kernels210), 2)
      if _283:
        xs203 = (_2212).forward(x23, )
      else:
        xs204 = torch.add_(xs199, (_2212).forward(x23, ))
        xs203 = xs204
      xs202 = xs203
    else:
      xs202 = xs199
    num_kernels211 = self.num_kernels
    _284 = torch.le(torch.mul(2, num_kernels211), 3)
    if _284:
      num_kernels212 = self.num_kernels
      _286 = torch.lt(3, torch.mul(3, num_kernels212))
      _285 = _286
    else:
      _285 = False
    if _285:
      num_kernels213 = self.num_kernels
      _287 = torch.eq(torch.mul(2, num_kernels213), 3)
      if _287:
        xs206 = (_3207).forward(x23, )
      else:
        xs207 = torch.add_(xs202, (_3207).forward(x23, ))
        xs206 = xs207
      xs205 = xs206
    else:
      xs205 = xs202
    num_kernels214 = self.num_kernels
    _288 = torch.le(torch.mul(2, num_kernels214), 4)
    if _288:
      num_kernels215 = self.num_kernels
      _290 = torch.lt(4, torch.mul(3, num_kernels215))
      _289 = _290
    else:
      _289 = False
    if _289:
      num_kernels216 = self.num_kernels
      _291 = torch.eq(torch.mul(2, num_kernels216), 4)
      if _291:
        xs209 = (_4203).forward(x23, )
      else:
        xs210 = torch.add_(xs205, (_4203).forward(x23, ))
        xs209 = xs210
      xs208 = xs209
    else:
      xs208 = xs205
    num_kernels217 = self.num_kernels
    _292 = torch.le(torch.mul(2, num_kernels217), 5)
    if _292:
      num_kernels218 = self.num_kernels
      _294 = torch.lt(5, torch.mul(3, num_kernels218))
      _293 = _294
    else:
      _293 = False
    if _293:
      num_kernels219 = self.num_kernels
      _295 = torch.eq(torch.mul(2, num_kernels219), 5)
      if _295:
        xs212 = (_5163).forward(x23, )
      else:
        xs213 = torch.add_(xs208, (_5163).forward(x23, ))
        xs212 = xs213
      xs211 = xs212
    else:
      xs211 = xs208
    num_kernels220 = self.num_kernels
    _296 = torch.le(torch.mul(2, num_kernels220), 6)
    if _296:
      num_kernels221 = self.num_kernels
      _298 = torch.lt(6, torch.mul(3, num_kernels221))
      _297 = _298
    else:
      _297 = False
    if _297:
      num_kernels222 = self.num_kernels
      _299 = torch.eq(torch.mul(2, num_kernels222), 6)
      if _299:
        xs215 = (_6155).forward(x23, )
      else:
        xs216 = torch.add_(xs211, (_6155).forward(x23, ))
        xs215 = xs216
      xs214 = xs215
    else:
      xs214 = xs211
    num_kernels223 = self.num_kernels
    _300 = torch.le(torch.mul(2, num_kernels223), 7)
    if _300:
      num_kernels224 = self.num_kernels
      _302 = torch.lt(7, torch.mul(3, num_kernels224))
      _301 = _302
    else:
      _301 = False
    if _301:
      num_kernels225 = self.num_kernels
      _303 = torch.eq(torch.mul(2, num_kernels225), 7)
      if _303:
        xs218 = (_7112).forward(x23, )
      else:
        xs219 = torch.add_(xs214, (_7112).forward(x23, ))
        xs218 = xs219
      xs217 = xs218
    else:
      xs217 = xs214
    num_kernels226 = self.num_kernels
    _304 = torch.le(torch.mul(2, num_kernels226), 8)
    if _304:
      num_kernels227 = self.num_kernels
      _306 = torch.lt(8, torch.mul(3, num_kernels227))
      _305 = _306
    else:
      _305 = False
    if _305:
      num_kernels228 = self.num_kernels
      _307 = torch.eq(torch.mul(2, num_kernels228), 8)
      if _307:
        xs221 = (_8109).forward(x23, )
      else:
        xs222 = torch.add_(xs217, (_8109).forward(x23, ))
        xs221 = xs222
      xs220 = xs221
    else:
      xs220 = xs217
    num_kernels229 = self.num_kernels
    x24 = torch.div(xs220, num_kernels229)
    x25 = _199(x24, 0.01, False, )
    conv_post = self.conv_post
    x26 = (conv_post).forward(x25, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _308 = torch.tanh(x26)
    else:
      _308 = (self).pqmf_synthesis(x26, )
    return _308
  def _forward_8(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    _309 = __torch__.torch.nn.functional.leaky_relu
    conv_pre = self.conv_pre
    _0 = getattr(conv_pre, "0")
    x27 = (_0).forward(x, )
    ups_8 = self.ups_8
    _0210 = getattr(ups_8, "0")
    _1 = getattr(ups_8, "1")
    LRELU_SLOPE = self.LRELU_SLOPE
    x28 = _309(x27, LRELU_SLOPE, False, )
    x29 = (_0210).forward(x28, None, )
    resblocks_8 = self.resblocks_8
    _0211 = getattr(resblocks_8, "0")
    _1215 = getattr(resblocks_8, "1")
    _2 = getattr(resblocks_8, "2")
    _3 = getattr(resblocks_8, "3")
    _4 = getattr(resblocks_8, "4")
    _5 = getattr(resblocks_8, "5")
    num_kernels = self.num_kernels
    _310 = torch.le(torch.mul(0, num_kernels), 0)
    if _310:
      num_kernels230 = self.num_kernels
      _312 = torch.lt(0, torch.mul(1, num_kernels230))
      _311 = _312
    else:
      _311 = False
    if _311:
      num_kernels231 = self.num_kernels
      _313 = torch.eq(torch.mul(0, num_kernels231), 0)
      if _313:
        xs223 = (_0211).forward(x29, )
      else:
        xs224 = torch.add_(x29, (_0211).forward(x29, ))
        xs223 = xs224
      xs = xs223
    else:
      xs = x29
    num_kernels232 = self.num_kernels
    _314 = torch.le(torch.mul(0, num_kernels232), 1)
    if _314:
      num_kernels233 = self.num_kernels
      _316 = torch.lt(1, torch.mul(1, num_kernels233))
      _315 = _316
    else:
      _315 = False
    if _315:
      num_kernels234 = self.num_kernels
      _317 = torch.eq(torch.mul(0, num_kernels234), 1)
      if _317:
        xs226 = (_1215).forward(x29, )
      else:
        xs227 = torch.add_(xs, (_1215).forward(x29, ))
        xs226 = xs227
      xs225 = xs226
    else:
      xs225 = xs
    num_kernels235 = self.num_kernels
    _318 = torch.le(torch.mul(0, num_kernels235), 2)
    if _318:
      num_kernels236 = self.num_kernels
      _320 = torch.lt(2, torch.mul(1, num_kernels236))
      _319 = _320
    else:
      _319 = False
    if _319:
      num_kernels237 = self.num_kernels
      _321 = torch.eq(torch.mul(0, num_kernels237), 2)
      if _321:
        xs229 = (_2).forward(x29, )
      else:
        xs230 = torch.add_(xs225, (_2).forward(x29, ))
        xs229 = xs230
      xs228 = xs229
    else:
      xs228 = xs225
    num_kernels238 = self.num_kernels
    _322 = torch.le(torch.mul(0, num_kernels238), 3)
    if _322:
      num_kernels239 = self.num_kernels
      _324 = torch.lt(3, torch.mul(1, num_kernels239))
      _323 = _324
    else:
      _323 = False
    if _323:
      num_kernels240 = self.num_kernels
      _325 = torch.eq(torch.mul(0, num_kernels240), 3)
      if _325:
        xs232 = (_3).forward(x29, )
      else:
        xs233 = torch.add_(xs228, (_3).forward(x29, ))
        xs232 = xs233
      xs231 = xs232
    else:
      xs231 = xs228
    num_kernels241 = self.num_kernels
    _326 = torch.le(torch.mul(0, num_kernels241), 4)
    if _326:
      num_kernels242 = self.num_kernels
      _328 = torch.lt(4, torch.mul(1, num_kernels242))
      _327 = _328
    else:
      _327 = False
    if _327:
      num_kernels243 = self.num_kernels
      _329 = torch.eq(torch.mul(0, num_kernels243), 4)
      if _329:
        xs235 = (_4).forward(x29, )
      else:
        xs236 = torch.add_(xs231, (_4).forward(x29, ))
        xs235 = xs236
      xs234 = xs235
    else:
      xs234 = xs231
    num_kernels244 = self.num_kernels
    _330 = torch.le(torch.mul(0, num_kernels244), 5)
    if _330:
      num_kernels245 = self.num_kernels
      _332 = torch.lt(5, torch.mul(1, num_kernels245))
      _331 = _332
    else:
      _331 = False
    if _331:
      num_kernels246 = self.num_kernels
      _333 = torch.eq(torch.mul(0, num_kernels246), 5)
      if _333:
        xs238 = (_5).forward(x29, )
      else:
        xs239 = torch.add_(xs234, (_5).forward(x29, ))
        xs238 = xs239
      xs237 = xs238
    else:
      xs237 = xs234
    num_kernels247 = self.num_kernels
    x30 = torch.div(xs237, num_kernels247)
    LRELU_SLOPE5 = self.LRELU_SLOPE
    x31 = _309(x30, LRELU_SLOPE5, False, )
    x32 = (_1).forward(x31, None, )
    resblocks_80 = self.resblocks_8
    _0212 = getattr(resblocks_80, "0")
    _1216 = getattr(resblocks_80, "1")
    _2213 = getattr(resblocks_80, "2")
    _3208 = getattr(resblocks_80, "3")
    _4204 = getattr(resblocks_80, "4")
    _5164 = getattr(resblocks_80, "5")
    num_kernels248 = self.num_kernels
    _334 = torch.le(torch.mul(1, num_kernels248), 0)
    if _334:
      num_kernels249 = self.num_kernels
      _336 = torch.lt(0, torch.mul(2, num_kernels249))
      _335 = _336
    else:
      _335 = False
    if _335:
      num_kernels250 = self.num_kernels
      _337 = torch.eq(torch.mul(1, num_kernels250), 0)
      if _337:
        xs241 = (_0212).forward(x32, )
      else:
        xs242 = torch.add_(x32, (_0212).forward(x32, ))
        xs241 = xs242
      xs240 = xs241
    else:
      xs240 = x32
    num_kernels251 = self.num_kernels
    _338 = torch.le(torch.mul(1, num_kernels251), 1)
    if _338:
      num_kernels252 = self.num_kernels
      _340 = torch.lt(1, torch.mul(2, num_kernels252))
      _339 = _340
    else:
      _339 = False
    if _339:
      num_kernels253 = self.num_kernels
      _341 = torch.eq(torch.mul(1, num_kernels253), 1)
      if _341:
        xs244 = (_1216).forward(x32, )
      else:
        xs245 = torch.add_(xs240, (_1216).forward(x32, ))
        xs244 = xs245
      xs243 = xs244
    else:
      xs243 = xs240
    num_kernels254 = self.num_kernels
    _342 = torch.le(torch.mul(1, num_kernels254), 2)
    if _342:
      num_kernels255 = self.num_kernels
      _344 = torch.lt(2, torch.mul(2, num_kernels255))
      _343 = _344
    else:
      _343 = False
    if _343:
      num_kernels256 = self.num_kernels
      _345 = torch.eq(torch.mul(1, num_kernels256), 2)
      if _345:
        xs247 = (_2213).forward(x32, )
      else:
        xs248 = torch.add_(xs243, (_2213).forward(x32, ))
        xs247 = xs248
      xs246 = xs247
    else:
      xs246 = xs243
    num_kernels257 = self.num_kernels
    _346 = torch.le(torch.mul(1, num_kernels257), 3)
    if _346:
      num_kernels258 = self.num_kernels
      _348 = torch.lt(3, torch.mul(2, num_kernels258))
      _347 = _348
    else:
      _347 = False
    if _347:
      num_kernels259 = self.num_kernels
      _349 = torch.eq(torch.mul(1, num_kernels259), 3)
      if _349:
        xs250 = (_3208).forward(x32, )
      else:
        xs251 = torch.add_(xs246, (_3208).forward(x32, ))
        xs250 = xs251
      xs249 = xs250
    else:
      xs249 = xs246
    num_kernels260 = self.num_kernels
    _350 = torch.le(torch.mul(1, num_kernels260), 4)
    if _350:
      num_kernels261 = self.num_kernels
      _352 = torch.lt(4, torch.mul(2, num_kernels261))
      _351 = _352
    else:
      _351 = False
    if _351:
      num_kernels262 = self.num_kernels
      _353 = torch.eq(torch.mul(1, num_kernels262), 4)
      if _353:
        xs253 = (_4204).forward(x32, )
      else:
        xs254 = torch.add_(xs249, (_4204).forward(x32, ))
        xs253 = xs254
      xs252 = xs253
    else:
      xs252 = xs249
    num_kernels263 = self.num_kernels
    _354 = torch.le(torch.mul(1, num_kernels263), 5)
    if _354:
      num_kernels264 = self.num_kernels
      _356 = torch.lt(5, torch.mul(2, num_kernels264))
      _355 = _356
    else:
      _355 = False
    if _355:
      num_kernels265 = self.num_kernels
      _357 = torch.eq(torch.mul(1, num_kernels265), 5)
      if _357:
        xs256 = (_5164).forward(x32, )
      else:
        xs257 = torch.add_(xs252, (_5164).forward(x32, ))
        xs256 = xs257
      xs255 = xs256
    else:
      xs255 = xs252
    num_kernels266 = self.num_kernels
    x33 = torch.div(xs255, num_kernels266)
    x34 = _309(x33, 0.01, False, )
    conv_post = self.conv_post
    x35 = (conv_post).forward(x34, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _358 = torch.tanh(x35)
    else:
      _358 = (self).pqmf_synthesis(x35, )
    return _358
