class ResBlock2(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  LRELU_SLOPE : float
  convs : __torch__.torch.nn.modules.container.___torch_mangle_14.ModuleList
  activations : __torch__.torch.nn.modules.container.___torch_mangle_15.ModuleList
  def forward(self: __torch__.vocoder.hifigan.generator.ResBlock2,
    x: Tensor) -> Tensor:
    convs = self.convs
    _0 = getattr(convs, "0")
    _1 = getattr(convs, "1")
    activations = self.activations
    _00 = getattr(activations, "0")
    _10 = getattr(activations, "1")
    xt = (_00).forward(x, )
    xt0 = (_0).forward(xt, )
    x0 = torch.add(xt0, x)
    xt1 = (_10).forward(x0, )
    xt2 = (_1).forward(xt1, )
    return torch.add(xt2, x0)
class SnakeBeta(Module):
  __parameters__ = ["alpha", "beta", ]
  __buffers__ = []
  alpha : Tensor
  beta : Tensor
  training : bool
  _is_full_backward_hook : Optional[bool]
  in_features : int
  alpha_logscale : bool
  no_div_by_zero : float
  def forward(self: __torch__.vocoder.hifigan.generator.SnakeBeta,
    x: Tensor) -> Tensor:
    alpha = self.alpha
    alpha0 = torch.unsqueeze(torch.unsqueeze(alpha, 0), -1)
    beta = self.beta
    beta0 = torch.unsqueeze(torch.unsqueeze(beta, 0), -1)
    alpha_logscale = self.alpha_logscale
    if alpha_logscale:
      alpha2 = torch.exp(alpha0)
      beta1, alpha1 = torch.exp(beta0), alpha2
    else:
      beta1, alpha1 = beta0, alpha0
    no_div_by_zero = self.no_div_by_zero
    _0 = torch.reciprocal(torch.add(beta1, no_div_by_zero))
    _1 = torch.mul(_0, 1.)
    _2 = torch.pow(torch.sin(torch.mul(x, alpha1)), 2)
    return torch.add(x, torch.mul(_1, _2))
