class Conv1d(Module):
  __parameters__ = ["weight", "bias", ]
  __buffers__ = []
  weight : Tensor
  bias : Optional[Tensor]
  training : bool
  _is_full_backward_hook : NoneType
  transposed : bool
  _reversed_padding_repeated_twice : List[int]
  stride : Final[Tuple[int]] = (1,)
  out_channels : Final[int] = 512
  in_channels : Final[int] = 128
  groups : Final[int] = 1
  padding_mode : Final[str] = "zeros"
  padding : Final[Tuple[int]] = (4,)
  output_padding : Final[Tuple[int]] = (0,)
  kernel_size : Final[Tuple[int]] = (9,)
  dilation : Final[Tuple[int]] = (1,)
  def forward(self: __torch__.torch.nn.modules.conv.Conv1d,
    input: Tensor) -> Tensor:
    weight = self.weight
    bias = self.bias
    _0 = (self)._conv_forward(input, weight, bias, )
    return _0
  def _conv_forward(self: __torch__.torch.nn.modules.conv.Conv1d,
    input: Tensor,
    weight: Tensor,
    bias: Optional[Tensor]) -> Tensor:
    _1 = torch.conv1d(input, weight, bias, [1], [4], [1])
    return _1
class ConvTranspose1d(Module):
  __parameters__ = ["bias", "weight", ]
  __buffers__ = []
  bias : Optional[Tensor]
  weight : Tensor
  training : bool
  _is_full_backward_hook : NoneType
  transposed : bool
  _reversed_padding_repeated_twice : List[int]
  stride : Final[Tuple[int]] = (3,)
  out_channels : Final[int] = 64
  in_channels : Final[int] = 128
  groups : Final[int] = 1
  padding_mode : Final[str] = "zeros"
  padding : Final[Tuple[int]] = (2,)
  output_padding : Final[Tuple[int]] = (1,)
  kernel_size : Final[Tuple[int]] = (6,)
  dilation : Final[Tuple[int]] = (1,)
  def forward(self: __torch__.torch.nn.modules.conv.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]]=None) -> Tensor:
    output_padding = (self)._output_padding(input, output_size, [3], [2], [6], 1, [1], )
    weight = self.weight
    bias = self.bias
    _2 = torch.conv_transpose1d(input, weight, bias, [3], [2], output_padding, 1, [1])
    return _2
  def _output_padding(self: __torch__.torch.nn.modules.conv.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]],
    stride: List[int],
    padding: List[int],
    kernel_size: List[int],
    num_spatial_dims: int,
    dilation: Optional[List[int]]=None) -> List[int]:
    _3 = "ConvTranspose{}D: for {}D input, output_size must have {} or {} elements (got {})"
    _4 = "requested an output size of {}, but valid sizes range from {} to {} (for an input of {})"
    if torch.__is__(output_size, None):
      ret = [1]
    else:
      output_size0 = unchecked_cast(List[int], output_size)
      has_batch_dim = torch.eq(torch.dim(input), torch.add(num_spatial_dims, 2))
      if has_batch_dim:
        num_non_spatial_dims = 2
      else:
        num_non_spatial_dims = 1
      _5 = torch.len(output_size0)
      _6 = torch.add(num_non_spatial_dims, num_spatial_dims)
      if torch.eq(_5, _6):
        output_size2 = torch.slice(output_size0, num_non_spatial_dims)
        output_size1 = output_size2
      else:
        output_size1 = output_size0
      _7 = torch.ne(torch.len(output_size1), num_spatial_dims)
      if _7:
        _8 = torch.dim(input)
        _9 = torch.add(num_non_spatial_dims, num_spatial_dims)
        _10 = torch.format(_3, num_spatial_dims, _8, num_spatial_dims, _9, torch.len(output_size1))
        ops.prim.RaiseException(_10, "builtins.ValueError")
      else:
        pass
      min_sizes = annotate(List[int], [])
      max_sizes = annotate(List[int], [])
      dilation0: Optional[List[int]] = dilation
      for d in range(num_spatial_dims):
        _11 = torch.add(d, num_non_spatial_dims)
        _12 = torch.sub(torch.size(input, _11), 1)
        _13 = torch.sub(torch.mul(_12, stride[d]), torch.mul(2, padding[d]))
        _14 = torch.__isnot__(dilation0, None)
        if _14:
          dilation2 = unchecked_cast(List[int], dilation0)
          _15, dilation1 = dilation2[d], dilation2
        else:
          _15, dilation1 = 1, dilation0
        _16 = torch.mul(_15, torch.sub(kernel_size[d], 1))
        dim_size = torch.add(torch.add(_13, _16), 1)
        _17 = torch.append(min_sizes, dim_size)
        _18 = torch.add(min_sizes[d], stride[d])
        _19 = torch.append(max_sizes, torch.sub(_18, 1))
        dilation0 = dilation1
      for i in range(torch.len(output_size1)):
        size = output_size1[i]
        min_size = min_sizes[i]
        max_size = max_sizes[i]
        if torch.lt(size, min_size):
          _20 = True
        else:
          _20 = torch.gt(size, max_size)
        if _20:
          _21 = torch.slice(torch.size(input), 2)
          _22 = torch.format(_4, output_size1, min_sizes, max_sizes, _21)
          ops.prim.RaiseException(_22, "builtins.ValueError")
        else:
          pass
      res = annotate(List[int], [])
      for d0 in range(num_spatial_dims):
        _23 = torch.sub(output_size1[d0], min_sizes[d0])
        _24 = torch.append(res, _23)
      ret = res
    return ret
