class Conv1d(Module):
  __parameters__ = ["weight", "bias", ]
  __buffers__ = []
  weight : Tensor
  bias : Optional[Tensor]
  training : bool
  _is_full_backward_hook : NoneType
  transposed : bool
  _reversed_padding_repeated_twice : List[int]
  out_channels : Final[int] = 512
  output_padding : Final[Tuple[int]] = (0,)
  padding : Final[Tuple[int]] = (4,)
  groups : Final[int] = 1
  padding_mode : Final[str] = "zeros"
  stride : Final[Tuple[int]] = (1,)
  dilation : Final[Tuple[int]] = (1,)
  in_channels : Final[int] = 128
  kernel_size : Final[Tuple[int]] = (9,)
  def forward(self: __torch__.torch.nn.modules.conv.Conv1d,
    input: Tensor) -> Tensor:
    weight = self.weight
    bias = self.bias
    _0 = (self)._conv_forward(input, weight, bias, )
    return _0
  def _conv_forward(self: __torch__.torch.nn.modules.conv.Conv1d,
    input: Tensor,
    weight: Tensor,
    bias: Optional[Tensor]) -> Tensor:
    _1 = torch.conv1d(input, weight, bias, [1], [4], [1])
    return _1
class ConvTranspose1d(Module):
  __parameters__ = ["bias", "weight", ]
  __buffers__ = []
  bias : Optional[Tensor]
  weight : Tensor
  training : bool
  _is_full_backward_hook : NoneType
  transposed : bool
  _reversed_padding_repeated_twice : List[int]
  out_channels : Final[int] = 256
  output_padding : Final[Tuple[int]] = (1,)
  padding : Final[Tuple[int]] = (2,)
  groups : Final[int] = 1
  padding_mode : Final[str] = "zeros"
  stride : Final[Tuple[int]] = (3,)
  dilation : Final[Tuple[int]] = (1,)
  in_channels : Final[int] = 512
  kernel_size : Final[Tuple[int]] = (6,)
  def forward(self: __torch__.torch.nn.modules.conv.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]]=None) -> Tensor:
    output_padding = (self)._output_padding(input, output_size, [3], [2], [6], [1], )
    weight = self.weight
    bias = self.bias
    _2 = torch.conv_transpose1d(input, weight, bias, [3], [2], output_padding, 1, [1])
    return _2
  def _output_padding(self: __torch__.torch.nn.modules.conv.ConvTranspose1d,
    input: Tensor,
    output_size: Optional[List[int]],
    stride: List[int],
    padding: List[int],
    kernel_size: List[int],
    dilation: Optional[List[int]]=None) -> List[int]:
    _3 = "output_size must have {} or {} elements (got {})"
    _4 = "requested an output size of {}, but valid sizes range from {} to {} (for an input of {})"
    if torch.__is__(output_size, None):
      ret = [1]
    else:
      output_size0 = unchecked_cast(List[int], output_size)
      k = torch.sub(torch.dim(input), 2)
      _5 = torch.eq(torch.len(output_size0), torch.add(k, 2))
      if _5:
        output_size1 = torch.slice(output_size0, 2)
      else:
        output_size1 = output_size0
      _6 = torch.ne(torch.len(output_size1), k)
      if _6:
        _7 = torch.format(_3, k, torch.add(k, 2), torch.len(output_size1))
        ops.prim.RaiseException(_7)
      else:
        pass
      min_sizes = annotate(List[int], [])
      max_sizes = annotate(List[int], [])
      dilation0: Optional[List[int]] = dilation
      for d in range(k):
        _8 = torch.size(input, torch.add(d, 2))
        _9 = torch.mul(torch.sub(_8, 1), stride[d])
        _10 = torch.sub(_9, torch.mul(2, padding[d]))
        _11 = torch.__isnot__(dilation0, None)
        if _11:
          dilation2 = unchecked_cast(List[int], dilation0)
          _12, dilation1 = dilation2[d], dilation2
        else:
          _12, dilation1 = 1, dilation0
        _13 = torch.mul(_12, torch.sub(kernel_size[d], 1))
        dim_size = torch.add(torch.add(_10, _13), 1)
        _14 = torch.append(min_sizes, dim_size)
        _15 = torch.add(min_sizes[d], stride[d])
        _16 = torch.append(max_sizes, torch.sub(_15, 1))
        dilation0 = dilation1
      for i in range(torch.len(output_size1)):
        size = output_size1[i]
        min_size = min_sizes[i]
        max_size = max_sizes[i]
        if torch.lt(size, min_size):
          _17 = True
        else:
          _17 = torch.gt(size, max_size)
        if _17:
          _18 = torch.slice(torch.size(input), 2)
          _19 = torch.format(_4, output_size1, min_sizes, max_sizes, _18)
          ops.prim.RaiseException(_19)
        else:
          pass
      res = annotate(List[int], [])
      for d0 in range(k):
        _20 = torch.sub(output_size1[d0], min_sizes[d0])
        _21 = torch.append(res, _20)
      ret = res
    return ret
