class AccentorTTSSystem(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  symbol_to_id : Dict[str, int]
  sos_token : str
  eos_token : str
  set_accent : bool
  stress_token : str
  yo_token : str
  e_token : str
  vowels : str
  exceptions : Dict[str, Tuple[int, int]]
  stop_words : List[str]
  stress_trs : float
  yo_trs : float
  tts_model : __torch__.silero_vocoder.jit_model.___torch_mangle_179.MultiTTSModel
  accentor : __torch__.g2p.accentor.models.accentor.AccentorNgramClean
  def forward(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    sentences: List[str],
    clean_sentences: List[str],
    break_lens: List[Optional[int]],
    prosody_rates: List[float],
    prosody_pitches: List[float],
    speaker_ids: Tensor,
    sr: int=48000,
    device: str="cpu",
    put_yo: bool=True,
    put_accent: bool=True,
    gt_durs: Optional[Tensor]=None,
    gt_pitch: Optional[Tensor]=None) -> Tuple[Tensor, Tensor]:
    if put_accent:
      acc_sentences0 = annotate(List[str], [])
      _0 = [torch.len(sentences), torch.len(clean_sentences)]
      for _1 in range(ops.prim.min(_0)):
        sentence = sentences[_1]
        clean_sentence = clean_sentences[_1]
        _2 = (self)._tokenize_clean(sentence, clean_sentence, )
        raw_tokens, clean_tokens, prediction_mask, = _2
        _3 = (self)._get_model_preds(clean_tokens, )
        stress_probs, stress_preds, yo_probs, yo_preds, = _3
        accented_sentence = (self).postprocess_accentor(raw_tokens, clean_tokens, prediction_mask, stress_probs, stress_preds, yo_probs, yo_preds, )
        acc_sentence = (self)._fuse_words_to_sentence(accented_sentence, )
        _4 = torch.append(acc_sentences0, acc_sentence)
      acc_sentences = acc_sentences0
    else:
      acc_sentences = sentences
    _5 = (self).merge_batch_model(acc_sentences, break_lens, prosody_rates, prosody_pitches, )
    sequence, symb_durs, durs_rate, pitch_coefs, = _5
    tts_model = self.tts_model
    _6 = torch.to(sequence, torch.device(device))
    _7 = torch.to(speaker_ids, torch.device(device))
    _8 = torch.to(durs_rate, torch.device(device))
    _9 = torch.to(pitch_coefs, torch.device(device))
    _10 = (tts_model).forward(_6, _7, sr, symb_durs, _8, _9, gt_durs, gt_pitch, device, )
    audio, audio_lengths, = _10
    return (audio, audio_lengths)
  def _tokenize_clean(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    sentence: str,
    clean_sentence: str) -> Tuple[List[str], List[str], List[bool]]:
    tokens = annotate(List[str], [])
    model_inputs = annotate(List[str], [])
    prediction_mask = annotate(List[bool], [])
    _11 = torch.split(sentence, " ")
    _12 = torch.split(clean_sentence, " ")
    _13 = ops.prim.min([torch.len(_11), torch.len(_12)])
    for _14 in range(_13):
      word = _11[_14]
      clean_word = _12[_14]
      parts = torch.split(word, "-")
      clean_parts = torch.split(clean_word, "-")
      if torch.eq(torch.len(parts), 1):
        cur_prediction_mask, cur_tokens = [True], parts
      else:
        _15 = annotate(List[str], [])
        _16 = torch.slice(parts, None, -1)
        for _17 in range(torch.len(_16)):
          part = _16[_17]
          _18 = torch.append(_15, torch.add(part, "-"))
        cur_tokens0 = torch.add(_15, [parts[-1]])
        _19 = annotate(List[bool], [])
        _20 = torch.len(torch.slice(parts, None, -1))
        for _21 in range(_20):
          _22 = torch.append(_19, True)
        _23 = clean_parts[-1]
        stop_words = self.stop_words
        _24 = torch.__contains__(stop_words, _23)
        cur_prediction_mask0 = torch.add(_19, [torch.__not__(_24)])
        cur_prediction_mask, cur_tokens = cur_prediction_mask0, cur_tokens0
      cur_prediction_mask1 = annotate(List[bool], [])
      _25 = [torch.len(clean_parts), torch.len(cur_prediction_mask)]
      for _26 in range(ops.prim.min(_25)):
        x = clean_parts[_26]
        mask = cur_prediction_mask[_26]
        _27 = torch.__and__(torch.gt(torch.len(x), 0), mask)
        _28 = torch.append(cur_prediction_mask1, _27)
      torch.extend(tokens, cur_tokens)
      torch.extend(model_inputs, clean_parts)
      torch.extend(prediction_mask, cur_prediction_mask1)
    _29 = (tokens, model_inputs, prediction_mask)
    return _29
  def _get_model_preds(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    words: List[str]) -> Tuple[Tensor, Tensor, Tensor, Tensor]:
    stress_logits, yo_logits, = (self).validate_ngrams(words, )
    stress_probs = torch.softmax(stress_logits, 1)
    stress_preds = torch.argmax(stress_probs, 1)
    yo_probs = torch.softmax(yo_logits, 1)
    yo_preds = torch.argmax(yo_probs, 1)
    _30 = (stress_probs, stress_preds, yo_probs, yo_preds)
    return _30
  def validate_ngrams(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    inputs: List[str]) -> Tuple[Tensor, Tensor]:
    _31 = __torch__.torch.autograd.grad_mode.no_grad.__new__(__torch__.torch.autograd.grad_mode.no_grad)
    _32 = (_31).__init__()
    with _31:
      accentor = self.accentor
      outs = (accentor).forward(inputs, )
    return outs
  def postprocess_accentor(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    raw_tokens: List[str],
    clean_tokens: List[str],
    prediction_mask: List[bool],
    stress_probs: Tensor,
    stress_preds: Tensor,
    yo_probs: Tensor,
    yo_preds: Tensor) -> List[str]:
    _33 = uninitialized(bool)
    accented_sentence = annotate(List[str], [])
    _34 = [9223372036854775807, torch.len(raw_tokens), torch.len(clean_tokens), torch.len(prediction_mask)]
    _35 = ops.prim.min(_34)
    _36 = 0
    _37 = torch.gt(_35, 0)
    while _37:
      raw_word = raw_tokens[_36]
      clean_word = clean_tokens[_36]
      need_processing = prediction_mask[_36]
      raw_word_lower = torch.lower(raw_word)
      if torch.__not__(need_processing):
        _41 = torch.append(accented_sentence, raw_word)
        _38, _39, _40 = True, True, _33
      else:
        stress_token = self.stress_token
        _42 = torch.find(raw_word_lower, stress_token, 0, torch.len(raw_word_lower))
        have_stress = torch.ne(_42, -1)
        yo_token = self.yo_token
        _43 = torch.find(raw_word_lower, yo_token, 0, torch.len(raw_word_lower))
        have_yo = torch.ne(_43, -1)
        if torch.eq(have_stress, True):
          _44 = torch.eq(have_yo, True)
        else:
          _44 = False
        if _44:
          _48 = torch.append(accented_sentence, raw_word)
          _45, _46, _47 = True, True, _33
        else:
          if torch.eq(have_stress, False):
            _49 = torch.eq(have_yo, True)
          else:
            _49 = False
          if _49:
            user_yo_positions = annotate(List[int], [])
            _53 = [9223372036854775807, torch.len(raw_word_lower)]
            for i in range(ops.prim.min(_53)):
              x = raw_word_lower[i]
              yo_token0 = self.yo_token
              if torch.eq(x, yo_token0):
                _54 = torch.append(user_yo_positions, i)
              else:
                pass
            _55 = torch.len(user_yo_positions)
            _56 = ops.prim.min([9223372036854775807, _55])
            raw_word0 = raw_word
            for i0 in range(_56):
              yo_pos = user_yo_positions[i0]
              _57 = torch.slice(raw_word0, None, torch.add(yo_pos, i0))
              stress_token0 = self.stress_token
              _58 = torch.add(_57, stress_token0)
              _59 = torch.slice(raw_word0, torch.add(yo_pos, i0))
              raw_word0 = torch.add(_58, _59)
            _60 = torch.append(accented_sentence, raw_word0)
            _50, _51, _52 = True, True, _33
          else:
            exceptions = self.exceptions
            _61 = torch.__contains__(exceptions, clean_word)
            if _61:
              _65 = (self)._accentuate_exception(clean_word, raw_word, have_stress, )
              _66 = torch.append(accented_sentence, _65)
              _62, _63, _64 = True, True, _33
            else:
              _67 = torch.select(stress_preds, 0, _36)
              stressed_vowel_ids = [int(_67)]
              _68 = torch.select(stress_probs, 0, _36)
              _69 = torch.select(_68, 0, stressed_vowel_ids[0])
              stress_trs = self.stress_trs
              passed_stress_trs = torch.gt(_69, stress_trs)
              if bool(passed_stress_trs):
                _70 = torch.__not__(have_stress)
                put_stress = _70
              else:
                put_stress = False
              _71 = torch.select(yo_preds, 0, _36)
              yo_vowel_ids = [int(_71)]
              _72 = torch.select(yo_probs, 0, _36)
              _73 = torch.select(_72, 0, yo_vowel_ids[0])
              yo_trs = self.yo_trs
              _74 = bool(torch.gt(_73, yo_trs))
              if _74:
                if bool(passed_stress_trs):
                  _75 = True
                else:
                  _75 = have_stress
                put_yo = _75
              else:
                put_yo = False
              if have_stress:
                stressed_vowel_ids1 = annotate(List[int], [])
                stress_token1 = self.stress_token
                _76 = torch.split(raw_word_lower, stress_token1)
                for _77 in range(torch.len(_76)):
                  stressed_part = _76[_77]
                  vowels = self.vowels
                  stressed_part_vowels_sum = 0
                  for _78 in range(torch.len(vowels)):
                    vowel = vowels[_78]
                    _79 = torch.count(stressed_part, vowel)
                    stressed_part_vowels_sum0 = torch.add(stressed_part_vowels_sum, _79)
                    stressed_part_vowels_sum = stressed_part_vowels_sum0
                  _80 = torch.append(stressed_vowel_ids1, stressed_part_vowels_sum)
                stressed_vowel_ids0 = stressed_vowel_ids1
              else:
                stressed_vowel_ids0 = stressed_vowel_ids
              _81 = (self)._get_positions(raw_word_lower, stressed_vowel_ids0, yo_vowel_ids, )
              stress_positions, yo_positions, num_vowels, first_vowel_pos, = _81
              if torch.eq(num_vowels, 0):
                _85 = torch.append(accented_sentence, raw_word)
                _82, _83, _84 = True, True, _33
              else:
                raw_word1 = raw_word
                for _86 in range(torch.len(yo_positions)):
                  yo_pos0 = yo_positions[_86]
                  _87 = torch.__contains__(stress_positions, yo_pos0)
                  if _87:
                    _88 = put_yo
                  else:
                    _88 = False
                  if _88:
                    _89 = raw_word_lower[yo_pos0]
                    e_token = self.e_token
                    _90 = torch.eq(_89, e_token)
                    if _90:
                      _91 = torch.slice(raw_word1, None, yo_pos0)
                      yo_token1 = self.yo_token
                      _92 = torch.add(_91, yo_token1)
                      _93 = torch.add(yo_pos0, 1)
                      _94 = torch.slice(raw_word1, _93)
                      raw_word4 = torch.add(_92, _94)
                      raw_word3 = raw_word4
                    else:
                      raw_word3 = raw_word1
                    raw_word2 = raw_word3
                  else:
                    raw_word2 = raw_word1
                  raw_word1 = raw_word2
                if torch.eq(num_vowels, 1):
                  put_stress0, stress_positions0 = True, [first_vowel_pos]
                else:
                  put_stress0, stress_positions0 = put_stress, stress_positions
                _95 = torch.__not__(have_stress)
                if _95:
                  _96 = put_stress0
                else:
                  _96 = False
                if _96:
                  _97 = torch.len(stress_positions0)
                  _98 = [9223372036854775807, _97]
                  raw_word6 = raw_word1
                  for i1 in range(ops.prim.min(_98)):
                    stress_pos = stress_positions0[i1]
                    _99 = torch.add(stress_pos, i1)
                    _100 = torch.slice(raw_word6, None, _99)
                    stress_token2 = self.stress_token
                    _101 = torch.add(_100, stress_token2)
                    _102 = torch.add(stress_pos, i1)
                    _103 = torch.slice(raw_word6, _102)
                    raw_word7 = torch.add(_101, _103)
                    raw_word6 = raw_word7
                  raw_word5 = raw_word6
                else:
                  raw_word5 = raw_word1
                _104 = torch.append(accented_sentence, raw_word5)
                _82, _83, _84 = False, _33, True
              _62, _63, _64 = _82, _83, _84
            _50, _51, _52 = _62, _63, _64
          _45, _46, _47 = _50, _51, _52
        _38, _39, _40 = _45, _46, _47
      if _38:
        _105 = _39
      else:
        _105 = _40
      _106 = torch.add(_36, 1)
      _107 = torch.__and__(torch.lt(_106, _35), _105)
      _37, _36 = _107, _106
    return accented_sentence
  def _accentuate_exception(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    clean_word: str,
    raw_word: str,
    have_stress: bool) -> str:
    exceptions = self.exceptions
    exc_stress = (exceptions[clean_word])[0]
    exceptions0 = self.exceptions
    exc_yo = (exceptions0[clean_word])[1]
    if have_stress:
      user_stress_token_positions = annotate(List[int], [])
      _108 = [9223372036854775807, torch.len(raw_word)]
      for i in range(ops.prim.min(_108)):
        c = raw_word[i]
        stress_token = self.stress_token
        if torch.eq(c, stress_token):
          _109 = torch.append(user_stress_token_positions, i)
        else:
          pass
      stress_token3 = self.stress_token
      accentuated_word0 = torch.replace(raw_word, stress_token3, "")
      if torch.ne(exc_yo, -1):
        _111 = torch.__contains__(user_stress_token_positions, torch.add(exc_yo, 1))
        _110 = _111
      else:
        _110 = False
      if _110:
        _112 = torch.slice(accentuated_word0, None, exc_yo)
        yo_token = self.yo_token
        _113 = torch.add(_112, yo_token)
        _114 = torch.slice(accentuated_word0, torch.add(exc_yo, 1))
        accentuated_word1 = torch.add(_113, _114)
      else:
        accentuated_word1 = accentuated_word0
      _115 = torch.len(user_stress_token_positions)
      accentuated_word2 = accentuated_word1
      for _116 in range(_115):
        stress_token_pos = user_stress_token_positions[_116]
        _117 = torch.slice(accentuated_word2, None, stress_token_pos)
        stress_token4 = self.stress_token
        _118 = torch.add(_117, stress_token4)
        _119 = torch.slice(accentuated_word2, stress_token_pos)
        accentuated_word2 = torch.add(_118, _119)
      accentuated_word = accentuated_word2
    else:
      if torch.ne(exc_yo, -1):
        _120 = torch.slice(raw_word, None, exc_yo)
        yo_token2 = self.yo_token
        _121 = torch.add(_120, yo_token2)
        _122 = torch.slice(raw_word, torch.add(exc_yo, 1))
        raw_word8 = torch.add(_121, _122)
      else:
        raw_word8 = raw_word
      _123 = torch.slice(raw_word8, None, exc_stress)
      stress_token5 = self.stress_token
      _124 = torch.add(_123, stress_token5)
      _125 = torch.slice(raw_word8, exc_stress)
      accentuated_word = torch.add(_124, _125)
    return accentuated_word
  def _get_positions(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    word: str,
    stressed_vowel_ids: List[int],
    yo_vowel_ids: List[int]) -> Tuple[List[int], List[int], int, int]:
    vowel_ids = annotate(List[int], [])
    ye_ids = annotate(List[int], [])
    _126 = [9223372036854775807, torch.len(word)]
    for i in range(ops.prim.min(_126)):
      c = word[i]
      vowels = self.vowels
      _127 = torch.find(vowels, c, 0, torch.len(vowels))
      if torch.ne(_127, -1):
        _128 = torch.append(vowel_ids, i)
      else:
        pass
      if torch.eq(c, "e"):
        _129 = torch.append(ye_ids, i)
      else:
        pass
    stress_positions = annotate(List[int], [])
    for _130 in range(torch.len(stressed_vowel_ids)):
      idx = stressed_vowel_ids[_130]
      _131 = torch.lt(idx, torch.len(vowel_ids))
      if _131:
        _133 = torch.gt(torch.len(vowel_ids), 0)
        _132 = _133
      else:
        _132 = False
      if _132:
        _134 = torch.append(stress_positions, vowel_ids[idx])
      else:
        pass
    yo_positions = annotate(List[int], [])
    for _135 in range(torch.len(yo_vowel_ids)):
      idx0 = yo_vowel_ids[_135]
      if torch.gt(idx0, 0):
        _137 = torch.lt(torch.sub(idx0, 1), torch.len(ye_ids))
        _136 = _137
      else:
        _136 = False
      if _136:
        _138 = torch.gt(torch.len(ye_ids), 0)
      else:
        _138 = False
      if _138:
        _139 = torch.append(yo_positions, ye_ids[torch.sub(idx0, 1)])
      else:
        pass
    num_vowels = torch.len(vowel_ids)
    if torch.gt(torch.len(vowel_ids), 0):
      first_vowel_pos = vowel_ids[0]
    else:
      first_vowel_pos = -1
    _140 = (stress_positions, yo_positions, num_vowels, first_vowel_pos)
    return _140
  def _fuse_words_to_sentence(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    words: List[str]) -> str:
    sentence = torch.replace(torch.join(" ", words), "- ", "-")
    return sentence
  def merge_batch_model(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    texts: List[str],
    break_lens: List[Optional[int]],
    prosody_rates: List[float],
    prosody_pitches: List[float]) -> Tuple[Tensor, Dict[int, int], Tensor, Tensor]:
    symb_durs = annotate(Dict[int, int], {})
    final_rates = annotate(List[float], [])
    final_pitches = annotate(List[float], [])
    _141 = [9223372036854775807, torch.len(break_lens)]
    text_len = -1
    for i in range(ops.prim.min(_141)):
      break_len = break_lens[i]
      _142 = torch.sub(torch.len(break_lens), 1)
      if torch.lt(i, _142):
        cur_text_len0 = torch.add(torch.len(texts[i]), 1)
        cur_text_len = cur_text_len0
      else:
        cur_text_len1 = torch.add(torch.len(texts[i]), 2)
        cur_text_len = cur_text_len1
      text_len0 = torch.add(text_len, cur_text_len)
      if torch.__isnot__(break_len, None):
        break_len0 = unchecked_cast(int, break_len)
        _143 = torch.sub(torch.len(break_lens), 1)
        if torch.lt(i, _143):
          torch._set_item(symb_durs, text_len0, break_len0)
        else:
          torch._set_item(symb_durs, torch.sub(text_len0, 1), break_len0)
      else:
        pass
      rate = prosody_rates[i]
      torch.extend(final_rates, torch.mul([rate], cur_text_len))
      pitch = prosody_pitches[i]
      torch.extend(final_pitches, torch.mul([pitch], cur_text_len))
      text_len = text_len0
    full_text = torch.join(" ", texts)
    _144 = (self).preprocess_tacotron(full_text, )
    text_tensor = torch.unsqueeze(_144, 0)
    rate_tensor = torch.unsqueeze(torch.tensor(final_rates), 0)
    pitch_tensor = torch.unsqueeze(torch.tensor(final_pitches), 0)
    _145 = (text_tensor, symb_durs, rate_tensor, pitch_tensor)
    return _145
  def preprocess_tacotron(self: __torch__.silero_vocoder.jit_model.___torch_mangle_180.AccentorTTSSystem,
    text: str) -> Tensor:
    sos_token = self.sos_token
    _146 = torch.add(sos_token, text)
    eos_token = self.eos_token
    text0 = torch.add(_146, eos_token)
    text_ohe = annotate(List[int], [])
    for _147 in range(torch.len(text0)):
      s = text0[_147]
      symbol_to_id = self.symbol_to_id
      _148 = torch.append(text_ohe, symbol_to_id[s])
    return torch.to(torch.tensor(text_ohe), 4)
