class JitMultiForward(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  device : Device
  n_mel_channels : int
  encoder_type : str
  pitch_strength : float
  padding_value : float
  log_dur : bool
  embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_177.Embedding
  speaker_embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_120.Embedding
  encoder : __torch__.tacotron2.fastpitch_layers.ForwardTransformer
  len_reg : __torch__.tacotron2.forward_layers.LengthRegulator
  pitch_proj : __torch__.torch.nn.modules.conv.___torch_mangle_2.Conv1d
  decoder : __torch__.tacotron2.fastpitch_layers.HourGlassTransformer
  lin : __torch__.torch.nn.modules.linear.___torch_mangle_5.Linear
  def forward(self: __torch__.jit_forward_model.___torch_mangle_178.JitMultiForward,
    inputs: Tensor,
    speaker_ids: Tensor,
    orig_mask: Tensor,
    dur_hat: Tensor,
    pitch_hat: Tensor) -> Tensor:
    embedding = self.embedding
    cond_embedded_inputs = (embedding).forward(inputs, )
    seq_len = torch.size(cond_embedded_inputs, 1)
    speaker_embedding = self.speaker_embedding
    _0 = (speaker_embedding).forward(speaker_ids, )
    speaker_embeds = torch.repeat(torch.unsqueeze(_0, 1), [1, seq_len, 1])
    encoder = self.encoder
    encoder_outputs = (encoder).forward(cond_embedded_inputs, orig_mask, )
    cond_encoder_outputs = torch.add(encoder_outputs, speaker_embeds)
    pitch_proj = self.pitch_proj
    pitch_proj0 = (pitch_proj).forward(pitch_hat, )
    pitch_proj1 = torch.transpose(pitch_proj0, 1, 2)
    pitch_strength = self.pitch_strength
    _1 = torch.mul(pitch_proj1, pitch_strength)
    cond_encoder_outputs0 = torch.add(cond_encoder_outputs, _1)
    len_reg = self.len_reg
    encoder_outputs_expanded = (len_reg).forward(cond_encoder_outputs0, dur_hat, )
    decoder = self.decoder
    outputs_expanded = (decoder).forward(encoder_outputs_expanded, None, )
    lin = self.lin
    mel_outputs = (lin).forward(outputs_expanded, )
    return torch.transpose(mel_outputs, 1, 2)
