class AccentorTTSSystem(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : NoneType
  symbol_to_id : Dict[str, int]
  sos_token : str
  eos_token : str
  set_accent : bool
  phons : bool
  phon_sep : str
  alphabet : List[str]
  stress_token : str
  yo_token : str
  e_token : str
  vowels : str
  exceptions : Dict[str, Tuple[int, int]]
  stop_words : List[str]
  stress_trs : float
  yo_trs : float
  phonemize_input : bool
  tts_model : __torch__.silero_vocoder.jit_model.MultiTTSModel
  accentor : __torch__.g2p.accentor.models.accentor.AccentorNgramClean
  def forward(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    sentences: List[str],
    clean_sentences: List[str],
    break_lens: List[Optional[int]],
    prosody_rates: List[float],
    prosody_pitches: List[float],
    speaker_ids: Tensor,
    sr: int=48000,
    device: str="cpu",
    put_yo: bool=True,
    put_accent: bool=True,
    gt_durs: Optional[Tensor]=None,
    gt_pitch: Optional[Tensor]=None) -> Tuple[Tensor, Tuple[Tensor, List[bool]]]:
    if put_accent:
      acc_sentences0 = annotate(List[str], [])
      _0 = [torch.len(sentences), torch.len(clean_sentences)]
      for _1 in range(ops.prim.min(_0)):
        sentence = sentences[_1]
        clean_sentence = clean_sentences[_1]
        _2 = (self)._tokenize_clean(sentence, clean_sentence, )
        raw_tokens, clean_tokens, prediction_mask, = _2
        _3 = (self)._get_model_preds(clean_tokens, )
        stress_probs, stress_preds, yo_probs, yo_preds, = _3
        accented_sentence = (self).postprocess_accentor(raw_tokens, clean_tokens, prediction_mask, stress_probs, stress_preds, yo_probs, yo_preds, put_yo, )
        acc_sentence = (self)._fuse_words_to_sentence(accented_sentence, )
        _4 = torch.append(acc_sentences0, acc_sentence)
      acc_sentences = acc_sentences0
    else:
      acc_sentences = sentences
    phon_sentences = annotate(List[str], [])
    for _5 in range(torch.len(acc_sentences)):
      s = acc_sentences[_5]
      _6 = torch.append(phon_sentences, torch.lower(s))
    _7 = (self).merge_batch_model(phon_sentences, break_lens, prosody_rates, prosody_pitches, )
    sequence, symb_durs, durs_rate, pitch_coefs, word_mask, = _7
    tts_model = self.tts_model
    _8 = torch.to(sequence, torch.device(device))
    _9 = torch.to(speaker_ids, torch.device(device))
    _10 = torch.to(durs_rate, torch.device(device))
    _11 = torch.to(pitch_coefs, torch.device(device))
    _12 = (tts_model).forward(_8, _9, sr, symb_durs, _10, _11, gt_durs, gt_pitch, device, )
    audio, durs, = _12
    return (audio, (durs, word_mask))
  def _tokenize_clean(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    sentence: str,
    clean_sentence: str) -> Tuple[List[str], List[str], List[bool]]:
    tokens = annotate(List[str], [])
    model_inputs = annotate(List[str], [])
    prediction_mask = annotate(List[bool], [])
    _13 = torch.split(sentence, " ")
    _14 = torch.split(clean_sentence, " ")
    _15 = ops.prim.min([torch.len(_13), torch.len(_14)])
    for _16 in range(_15):
      word = _13[_16]
      clean_word = _14[_16]
      parts = torch.split(word, "-")
      clean_parts = torch.split(clean_word, "-")
      if torch.eq(torch.len(parts), 1):
        cur_prediction_mask, cur_tokens = [True], parts
      else:
        _17 = annotate(List[str], [])
        _18 = torch.slice(parts, None, -1)
        for _19 in range(torch.len(_18)):
          part = _18[_19]
          _20 = torch.append(_17, torch.add(part, "-"))
        cur_tokens0 = torch.add(_17, [parts[-1]])
        _21 = annotate(List[bool], [])
        _22 = torch.len(torch.slice(parts, None, -1))
        for _23 in range(_22):
          _24 = torch.append(_21, True)
        _25 = clean_parts[-1]
        stop_words = self.stop_words
        _26 = torch.__contains__(stop_words, _25)
        cur_prediction_mask0 = torch.add(_21, [torch.__not__(_26)])
        cur_prediction_mask, cur_tokens = cur_prediction_mask0, cur_tokens0
      cur_prediction_mask1 = annotate(List[bool], [])
      _27 = [torch.len(clean_parts), torch.len(cur_prediction_mask)]
      for _28 in range(ops.prim.min(_27)):
        x = clean_parts[_28]
        mask = cur_prediction_mask[_28]
        _29 = torch.__and__(torch.gt(torch.len(x), 0), mask)
        _30 = torch.append(cur_prediction_mask1, _29)
      torch.extend(tokens, cur_tokens)
      torch.extend(model_inputs, clean_parts)
      torch.extend(prediction_mask, cur_prediction_mask1)
    _31 = (tokens, model_inputs, prediction_mask)
    return _31
  def _get_model_preds(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    words: List[str]) -> Tuple[Tensor, Tensor, Tensor, Tensor]:
    stress_logits, yo_logits, = (self).validate_ngrams(words, )
    stress_probs = torch.softmax(stress_logits, 1)
    stress_preds = torch.argmax(stress_probs, 1)
    yo_probs = torch.softmax(yo_logits, 1)
    yo_preds = torch.argmax(yo_probs, 1)
    _32 = (stress_probs, stress_preds, yo_probs, yo_preds)
    return _32
  def validate_ngrams(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    inputs: List[str]) -> Tuple[Tensor, Tensor]:
    _33 = __torch__.torch.autograd.grad_mode.no_grad.__new__(__torch__.torch.autograd.grad_mode.no_grad)
    _34 = (_33).__init__()
    with _33:
      accentor = self.accentor
      outs = (accentor).forward(inputs, )
    return outs
  def postprocess_accentor(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    raw_tokens: List[str],
    clean_tokens: List[str],
    prediction_mask: List[bool],
    stress_probs: Tensor,
    stress_preds: Tensor,
    yo_probs: Tensor,
    yo_preds: Tensor,
    should_put_yo: bool) -> List[str]:
    _35 = uninitialized(bool)
    accented_sentence = annotate(List[str], [])
    _36 = [9223372036854775807, torch.len(raw_tokens), torch.len(clean_tokens), torch.len(prediction_mask)]
    _37 = ops.prim.min(_36)
    _38 = 0
    _39 = torch.gt(_37, 0)
    while _39:
      raw_word = raw_tokens[_38]
      clean_word = clean_tokens[_38]
      need_processing = prediction_mask[_38]
      raw_word_lower = torch.lower(raw_word)
      if torch.__not__(need_processing):
        _43 = torch.append(accented_sentence, raw_word)
        _40, _41, _42 = True, True, _35
      else:
        stress_token = self.stress_token
        _44 = torch.find(raw_word_lower, stress_token, 0, torch.len(raw_word_lower))
        have_stress = torch.ne(_44, -1)
        yo_token = self.yo_token
        _45 = torch.find(raw_word_lower, yo_token, 0, torch.len(raw_word_lower))
        have_yo = torch.ne(_45, -1)
        if torch.eq(have_stress, True):
          _46 = torch.eq(have_yo, True)
        else:
          _46 = False
        if _46:
          _50 = torch.append(accented_sentence, raw_word)
          _47, _48, _49 = True, True, _35
        else:
          if torch.eq(have_stress, False):
            _51 = torch.eq(have_yo, True)
          else:
            _51 = False
          if _51:
            user_yo_positions = annotate(List[int], [])
            _55 = [9223372036854775807, torch.len(raw_word_lower)]
            for i in range(ops.prim.min(_55)):
              x = raw_word_lower[i]
              yo_token0 = self.yo_token
              if torch.eq(x, yo_token0):
                _56 = torch.append(user_yo_positions, i)
              else:
                pass
            _57 = torch.len(user_yo_positions)
            _58 = ops.prim.min([9223372036854775807, _57])
            raw_word0 = raw_word
            for i0 in range(_58):
              yo_pos = user_yo_positions[i0]
              _59 = torch.slice(raw_word0, None, torch.add(yo_pos, i0))
              stress_token0 = self.stress_token
              _60 = torch.add(_59, stress_token0)
              _61 = torch.slice(raw_word0, torch.add(yo_pos, i0))
              raw_word0 = torch.add(_60, _61)
            _62 = torch.append(accented_sentence, raw_word0)
            _52, _53, _54 = True, True, _35
          else:
            exceptions = self.exceptions
            _63 = torch.__contains__(exceptions, clean_word)
            if _63:
              _67 = (self)._accentuate_exception(clean_word, raw_word, have_stress, should_put_yo, )
              _68 = torch.append(accented_sentence, _67)
              _64, _65, _66 = True, True, _35
            else:
              _69 = torch.select(stress_preds, 0, _38)
              stressed_vowel_ids = [int(_69)]
              _70 = torch.select(stress_probs, 0, _38)
              _71 = torch.select(_70, 0, stressed_vowel_ids[0])
              stress_trs = self.stress_trs
              passed_stress_trs = torch.gt(_71, stress_trs)
              if bool(passed_stress_trs):
                _72 = torch.__not__(have_stress)
                put_stress = _72
              else:
                put_stress = False
              _73 = torch.select(yo_preds, 0, _38)
              yo_vowel_ids = [int(_73)]
              _74 = torch.select(yo_probs, 0, _38)
              _75 = torch.select(_74, 0, yo_vowel_ids[0])
              yo_trs = self.yo_trs
              _76 = bool(torch.gt(_75, yo_trs))
              if should_put_yo:
                _77 = _76
              else:
                _77 = False
              if _77:
                if bool(passed_stress_trs):
                  _78 = True
                else:
                  _78 = have_stress
                put_yo = _78
              else:
                put_yo = False
              if have_stress:
                stressed_vowel_ids1 = annotate(List[int], [])
                stress_token1 = self.stress_token
                _79 = torch.split(raw_word_lower, stress_token1)
                for _80 in range(torch.len(_79)):
                  stressed_part = _79[_80]
                  vowels = self.vowels
                  stressed_part_vowels_sum = 0
                  for _81 in range(torch.len(vowels)):
                    vowel = vowels[_81]
                    _82 = torch.count(stressed_part, vowel)
                    stressed_part_vowels_sum0 = torch.add(stressed_part_vowels_sum, _82)
                    stressed_part_vowels_sum = stressed_part_vowels_sum0
                  _83 = torch.append(stressed_vowel_ids1, stressed_part_vowels_sum)
                stressed_vowel_ids0 = stressed_vowel_ids1
              else:
                stressed_vowel_ids0 = stressed_vowel_ids
              _84 = (self)._get_positions(raw_word_lower, stressed_vowel_ids0, yo_vowel_ids, )
              stress_positions, yo_positions, num_vowels, first_vowel_pos, = _84
              if torch.eq(num_vowels, 0):
                _88 = torch.append(accented_sentence, raw_word)
                _85, _86, _87 = True, True, _35
              else:
                raw_word1 = raw_word
                for _89 in range(torch.len(yo_positions)):
                  yo_pos0 = yo_positions[_89]
                  _90 = torch.__contains__(stress_positions, yo_pos0)
                  if _90:
                    _91 = put_yo
                  else:
                    _91 = False
                  if _91:
                    _92 = raw_word_lower[yo_pos0]
                    e_token = self.e_token
                    _93 = torch.eq(_92, e_token)
                    if _93:
                      _94 = torch.slice(raw_word1, None, yo_pos0)
                      yo_token1 = self.yo_token
                      _95 = torch.add(_94, yo_token1)
                      _96 = torch.add(yo_pos0, 1)
                      _97 = torch.slice(raw_word1, _96)
                      raw_word4 = torch.add(_95, _97)
                      raw_word3 = raw_word4
                    else:
                      raw_word3 = raw_word1
                    raw_word2 = raw_word3
                  else:
                    raw_word2 = raw_word1
                  raw_word1 = raw_word2
                if torch.eq(num_vowels, 1):
                  put_stress0, stress_positions0 = True, [first_vowel_pos]
                else:
                  put_stress0, stress_positions0 = put_stress, stress_positions
                _98 = torch.__not__(have_stress)
                if _98:
                  _99 = put_stress0
                else:
                  _99 = False
                if _99:
                  _100 = torch.len(stress_positions0)
                  _101 = [9223372036854775807, _100]
                  raw_word6 = raw_word1
                  for i1 in range(ops.prim.min(_101)):
                    stress_pos = stress_positions0[i1]
                    _102 = torch.add(stress_pos, i1)
                    _103 = torch.slice(raw_word6, None, _102)
                    stress_token2 = self.stress_token
                    _104 = torch.add(_103, stress_token2)
                    _105 = torch.add(stress_pos, i1)
                    _106 = torch.slice(raw_word6, _105)
                    raw_word7 = torch.add(_104, _106)
                    raw_word6 = raw_word7
                  raw_word5 = raw_word6
                else:
                  raw_word5 = raw_word1
                _107 = torch.append(accented_sentence, raw_word5)
                _85, _86, _87 = False, _35, True
              _64, _65, _66 = _85, _86, _87
            _52, _53, _54 = _64, _65, _66
          _47, _48, _49 = _52, _53, _54
        _40, _41, _42 = _47, _48, _49
      if _40:
        _108 = _41
      else:
        _108 = _42
      _109 = torch.add(_38, 1)
      _110 = torch.__and__(torch.lt(_109, _37), _108)
      _39, _38 = _110, _109
    return accented_sentence
  def _accentuate_exception(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    clean_word: str,
    raw_word: str,
    have_stress: bool,
    should_put_yo: bool) -> str:
    exceptions = self.exceptions
    exc_stress = (exceptions[clean_word])[0]
    exceptions0 = self.exceptions
    exc_yo = (exceptions0[clean_word])[1]
    if have_stress:
      user_stress_token_positions = annotate(List[int], [])
      _111 = [9223372036854775807, torch.len(raw_word)]
      for i in range(ops.prim.min(_111)):
        c = raw_word[i]
        stress_token = self.stress_token
        if torch.eq(c, stress_token):
          _112 = torch.append(user_stress_token_positions, i)
        else:
          pass
      stress_token3 = self.stress_token
      accentuated_word0 = torch.replace(raw_word, stress_token3, "")
      if should_put_yo:
        _113 = torch.ne(exc_yo, -1)
      else:
        _113 = False
      if _113:
        _115 = torch.__contains__(user_stress_token_positions, torch.add(exc_yo, 1))
        _114 = _115
      else:
        _114 = False
      if _114:
        _116 = torch.slice(accentuated_word0, None, exc_yo)
        yo_token = self.yo_token
        _117 = torch.add(_116, yo_token)
        _118 = torch.slice(accentuated_word0, torch.add(exc_yo, 1))
        accentuated_word1 = torch.add(_117, _118)
      else:
        accentuated_word1 = accentuated_word0
      _119 = torch.len(user_stress_token_positions)
      accentuated_word2 = accentuated_word1
      for _120 in range(_119):
        stress_token_pos = user_stress_token_positions[_120]
        _121 = torch.slice(accentuated_word2, None, stress_token_pos)
        stress_token4 = self.stress_token
        _122 = torch.add(_121, stress_token4)
        _123 = torch.slice(accentuated_word2, stress_token_pos)
        accentuated_word2 = torch.add(_122, _123)
      accentuated_word = accentuated_word2
    else:
      if should_put_yo:
        _124 = torch.ne(exc_yo, -1)
      else:
        _124 = False
      if _124:
        _125 = torch.slice(raw_word, None, exc_yo)
        yo_token2 = self.yo_token
        _126 = torch.add(_125, yo_token2)
        _127 = torch.slice(raw_word, torch.add(exc_yo, 1))
        raw_word8 = torch.add(_126, _127)
      else:
        raw_word8 = raw_word
      _128 = torch.slice(raw_word8, None, exc_stress)
      stress_token5 = self.stress_token
      _129 = torch.add(_128, stress_token5)
      _130 = torch.slice(raw_word8, exc_stress)
      accentuated_word = torch.add(_129, _130)
    return accentuated_word
  def _get_positions(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    word: str,
    stressed_vowel_ids: List[int],
    yo_vowel_ids: List[int]) -> Tuple[List[int], List[int], int, int]:
    vowel_ids = annotate(List[int], [])
    ye_ids = annotate(List[int], [])
    _131 = [9223372036854775807, torch.len(word)]
    for i in range(ops.prim.min(_131)):
      c = word[i]
      vowels = self.vowels
      _132 = torch.find(vowels, c, 0, torch.len(vowels))
      if torch.ne(_132, -1):
        _133 = torch.append(vowel_ids, i)
      else:
        pass
      if torch.eq(c, "e"):
        _134 = torch.append(ye_ids, i)
      else:
        pass
    stress_positions = annotate(List[int], [])
    for _135 in range(torch.len(stressed_vowel_ids)):
      idx = stressed_vowel_ids[_135]
      _136 = torch.lt(idx, torch.len(vowel_ids))
      if _136:
        _138 = torch.gt(torch.len(vowel_ids), 0)
        _137 = _138
      else:
        _137 = False
      if _137:
        _139 = torch.append(stress_positions, vowel_ids[idx])
      else:
        pass
    yo_positions = annotate(List[int], [])
    for _140 in range(torch.len(yo_vowel_ids)):
      idx0 = yo_vowel_ids[_140]
      if torch.gt(idx0, 0):
        _142 = torch.lt(torch.sub(idx0, 1), torch.len(ye_ids))
        _141 = _142
      else:
        _141 = False
      if _141:
        _143 = torch.gt(torch.len(ye_ids), 0)
      else:
        _143 = False
      if _143:
        _144 = torch.append(yo_positions, ye_ids[torch.sub(idx0, 1)])
      else:
        pass
    num_vowels = torch.len(vowel_ids)
    if torch.gt(torch.len(vowel_ids), 0):
      first_vowel_pos = vowel_ids[0]
    else:
      first_vowel_pos = -1
    _145 = (stress_positions, yo_positions, num_vowels, first_vowel_pos)
    return _145
  def _fuse_words_to_sentence(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    words: List[str]) -> str:
    sentence = torch.replace(torch.join(" ", words), "- ", "-")
    return sentence
  def merge_batch_model(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    texts: List[str],
    break_lens: List[Optional[int]],
    prosody_rates: List[float],
    prosody_pitches: List[float]) -> Tuple[Tensor, Dict[int, int], Tensor, Tensor, List[bool]]:
    split_texts = annotate(List[List[str]], [])
    for _146 in range(torch.len(texts)):
      t = texts[_146]
      phons = self.phons
      if phons:
        phon_sep = self.phon_sep
        _147 = torch.append(split_texts, torch.split(t, phon_sep))
      else:
        _148 = torch.append(split_texts, torch.list(t))
    symb_durs = annotate(Dict[int, int], {})
    final_rates = annotate(List[float], [])
    final_pitches = annotate(List[float], [])
    _149 = [9223372036854775807, torch.len(break_lens)]
    text_len = -1
    for i in range(ops.prim.min(_149)):
      break_len = break_lens[i]
      _150 = torch.sub(torch.len(break_lens), 1)
      if torch.lt(i, _150):
        cur_text_len0 = torch.add(torch.len(split_texts[i]), 1)
        cur_text_len = cur_text_len0
      else:
        cur_text_len1 = torch.add(torch.len(split_texts[i]), 2)
        cur_text_len = cur_text_len1
      phons0 = self.phons
      if phons0:
        _151 = torch.eq(i, 0)
      else:
        _151 = False
      if _151:
        cur_text_len2 = torch.sub(cur_text_len, 1)
      else:
        cur_text_len2 = cur_text_len
      text_len0 = torch.add(text_len, cur_text_len2)
      if torch.__isnot__(break_len, None):
        break_len0 = unchecked_cast(int, break_len)
        _152 = torch.sub(torch.len(break_lens), 1)
        if torch.lt(i, _152):
          torch._set_item(symb_durs, text_len0, break_len0)
        else:
          torch._set_item(symb_durs, torch.sub(text_len0, 1), break_len0)
      else:
        pass
      rate = prosody_rates[i]
      torch.extend(final_rates, torch.mul([rate], cur_text_len2))
      pitch = prosody_pitches[i]
      torch.extend(final_pitches, torch.mul([pitch], cur_text_len2))
      text_len = text_len0
    phons1 = self.phons
    if phons1:
      phon_sep0 = self.phon_sep
      if torch.eq(phon_sep0, " "):
        full_text0 = torch.join(" <sep> ", texts)
      else:
        phon_sep1 = self.phon_sep
        phon_sep2 = self.phon_sep
        _153 = torch.format("{} {}", phon_sep1, phon_sep2)
        full_text0 = torch.join(_153, texts)
      full_text = full_text0
    else:
      full_text = torch.join(" ", texts)
    _154 = (self).preprocess_tacotron(full_text, )
    text_tensor, word_mask, = _154
    text_tensor0 = torch.unsqueeze(text_tensor, 0)
    rate_tensor = torch.unsqueeze(torch.tensor(final_rates), 0)
    pitch_tensor = torch.unsqueeze(torch.tensor(final_pitches), 0)
    _155 = (text_tensor0, symb_durs, rate_tensor, pitch_tensor, word_mask)
    return _155
  def preprocess_tacotron(self: __torch__.silero_vocoder.jit_model.AccentorTTSSystem,
    text: str) -> Tuple[Tensor, List[bool]]:
    phons = self.phons
    if phons:
      phon_sep = self.phon_sep
      _156 = torch.add(text, phon_sep)
      eos_token = self.eos_token
      text0 = torch.add(_156, eos_token)
      phon_sep3 = self.phon_sep
      split_text = torch.split(text0, phon_sep3)
    else:
      sos_token = self.sos_token
      _157 = torch.add(sos_token, text)
      eos_token0 = self.eos_token
      text1 = torch.add(_157, eos_token0)
      split_text = torch.list(text1)
    text_ohe = annotate(List[int], [])
    word_mask = annotate(List[bool], [])
    for _158 in range(torch.len(split_text)):
      s = split_text[_158]
      symbol_to_id = self.symbol_to_id
      _159 = torch.append(text_ohe, symbol_to_id[s])
      alphabet = self.alphabet
      _160 = torch.append(word_mask, torch.__contains__(alphabet, s))
    text_tensor = torch.to(torch.tensor(text_ohe), 4)
    return (text_tensor, word_mask)
class MultiTTSModel(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  point_id : int
  comma_ids : List[int]
  mean_std_coef : List[float]
  sil_value : float
  tacotron : __torch__.jit_forward_model.JitMultiForward
  vocoder : __torch__.vocoder.hifigan.jit_vocoder.JitGenerator
  dur_predictor : __torch__.jit_forward_model.JitDurPredictor
  pitch_predictor : __torch__.jit_forward_model.JitPitchPredictor
  def forward(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    sequence: Tensor,
    speaker_ids: Tensor,
    sr: int=48000,
    symb_durs: Optional[Dict[int, int]]=None,
    durs_rate: Optional[Tensor]=None,
    pitch_coefs: Optional[Tensor]=None,
    gt_durs: Optional[Tensor]=None,
    gt_pitch: Optional[Tensor]=None,
    device: str="cpu") -> Tuple[Tensor, Tensor]:
    _161 = __torch__.tacotron2.fastpitch_layers.make_token_len_mask
    _162 = uninitialized(Tensor)
    _163 = _161(torch.transpose(sequence, 0, 1), )
    orig_mask = torch.to(_163, torch.device(device))
    if torch.__isnot__(symb_durs, None):
      symb_durs1 = unchecked_cast(Dict[int, int], symb_durs)
      _165 = torch.gt(torch.len(symb_durs1), 0)
      _164, symb_durs0 = _165, symb_durs1
    else:
      _164, symb_durs0 = False, symb_durs
    if _164:
      symb_durs3 = unchecked_cast(Dict[int, int], symb_durs0)
      support_ids0 = (self).get_support_ids(sequence, symb_durs3, )
      support_ids, symb_durs2 = support_ids0, symb_durs3
    else:
      support_ids, symb_durs2 = None, symb_durs0
    if torch.__isnot__(support_ids, None):
      support_ids2 = unchecked_cast(List[int], support_ids)
      support_sequence0 = (self).replace_comma(sequence, support_ids2, )
      support_ids1, support_sequence = support_ids2, support_sequence0
    else:
      support_ids1, support_sequence = support_ids, sequence
    if torch.__is__(gt_durs, None):
      if torch.__isnot__(symb_durs2, None):
        symb_durs6 = unchecked_cast(Dict[int, int], symb_durs2)
        _167 = torch.gt(torch.len(symb_durs6), 0)
        _166, symb_durs5 = _167, symb_durs6
      else:
        _166, symb_durs5 = False, symb_durs2
      if _166:
        symb_durs8 = unchecked_cast(Dict[int, int], symb_durs5)
        _169 = torch.__isnot__(support_ids1, None)
        _168, symb_durs7 = _169, symb_durs8
      else:
        _168, symb_durs7 = False, symb_durs5
      if _168:
        symb_durs10 = unchecked_cast(Dict[int, int], symb_durs7)
        support_ids4 = unchecked_cast(List[int], support_ids1)
        _170 = torch.eq((torch.size(sequence))[0], 1)
        if _170:
          pass
        else:
          ops.prim.RaiseException("AssertionError: ")
        support_sequence1 = torch.to(support_sequence, torch.device(device))
        dur_predictor = self.dur_predictor
        _171 = torch.cat([sequence, support_sequence1])
        _172 = torch.cat([orig_mask, orig_mask])
        pred_log_dur0 = (dur_predictor).forward(_171, speaker_ids, _172, 1., )
        pred_log_dur, symb_durs9, support_ids3 = pred_log_dur0, symb_durs10, support_ids4
      else:
        dur_predictor0 = self.dur_predictor
        pred_log_dur1 = (dur_predictor0).forward(sequence, speaker_ids, orig_mask, 1., )
        pred_log_dur, symb_durs9, support_ids3 = pred_log_dur1, symb_durs7, support_ids1
      pred_log_dur2 = torch.sub(torch.exp(pred_log_dur), 1)
      _173 = torch.lt(pred_log_dur2, 0.)
      _174 = torch.tensor(0., dtype=ops.prim.dtype(pred_log_dur2), device=ops.prim.device(pred_log_dur2))
      _175 = annotate(List[Optional[Tensor]], [_173])
      _176 = torch.index_put_(pred_log_dur2, _175, _174)
      dur_hat0 = torch.round(pred_log_dur2)
      if torch.__isnot__(symb_durs9, None):
        symb_durs12 = unchecked_cast(Dict[int, int], symb_durs9)
        _178 = torch.gt(torch.len(symb_durs12), 0)
        _177, symb_durs11 = _178, symb_durs12
      else:
        _177, symb_durs11 = False, symb_durs9
      if _177:
        symb_durs14 = unchecked_cast(Dict[int, int], symb_durs11)
        _179 = torch.__isnot__(support_ids3, None)
        if _179:
          support_ids5 = unchecked_cast(List[int], support_ids3)
          sdurs = annotate(List[int], [])
          for _180 in range(torch.len(support_ids5)):
            sid = support_ids5[_180]
            _181 = torch.append(sdurs, symb_durs14[sid])
          pause_len = ops.prim.max(sdurs)
          dur_hat3 = (self).process_pauses(pred_log_dur2, support_ids5, pause_len, )
          dur_hat2 = dur_hat3
        else:
          dur_hat2 = dur_hat0
        dur_hat1, symb_durs13 = dur_hat2, symb_durs14
      else:
        dur_hat1, symb_durs13 = dur_hat0, symb_durs11
      if torch.__isnot__(durs_rate, None):
        durs_rate0 = unchecked_cast(Tensor, durs_rate)
        _182 = torch.eq(torch.size(durs_rate0), torch.size(dur_hat1))
        if _182:
          pass
        else:
          ops.prim.RaiseException("AssertionError: ")
        dur_hat5 = torch.div(dur_hat1, durs_rate0)
        dur_hat4 = torch.round(dur_hat5)
      else:
        dur_hat4 = dur_hat1
      _183 = torch.__isnot__(symb_durs13, None)
      if _183:
        symb_durs16 = unchecked_cast(Dict[int, int], symb_durs13)
        _185 = torch.gt(torch.len(symb_durs16), 0)
        _184, symb_durs15 = _185, symb_durs16
      else:
        _184, symb_durs15 = False, symb_durs13
      if _184:
        symb_durs18 = unchecked_cast(Dict[int, int], symb_durs15)
        _186 = torch.items(symb_durs18)
        for _187 in range(torch.len(_186)):
          sid0, sdur, = _186[_187]
          _188 = torch.select(torch.select(dur_hat4, 0, 0), 0, sid0)
          _189 = torch.tensor(sdur, dtype=ops.prim.dtype(_188), device=ops.prim.device(_188))
          _190 = torch.copy_(_188, _189)
        symb_durs17 : Optional[Dict[int, int]] = symb_durs18
      else:
        symb_durs17 = symb_durs15
      dur_hat, symb_durs4 = dur_hat4, symb_durs17
    else:
      dur_hat, symb_durs4 = unchecked_cast(Tensor, gt_durs), symb_durs2
    if torch.__is__(gt_pitch, None):
      pitch_predictor = self.pitch_predictor
      pitch_hat0 = (pitch_predictor).forward(sequence, speaker_ids, orig_mask, 1., )
      _191 = torch.__isnot__(pitch_coefs, None)
      if _191:
        pitch_coefs0 = unchecked_cast(Tensor, pitch_coefs)
        pitch_hat2 = (self).update_pitch_coef(pitch_hat0, pitch_coefs0, speaker_ids, )
        pitch_hat1 = pitch_hat2
      else:
        pitch_hat1 = pitch_hat0
      pitch_hat = pitch_hat1
    else:
      pitch_hat = unchecked_cast(Tensor, gt_pitch)
    tacotron = self.tacotron
    mel_outputs = (tacotron).forward(sequence, speaker_ids, orig_mask, dur_hat, pitch_hat, )
    if torch.__isnot__(symb_durs4, None):
      symb_durs20 = unchecked_cast(Dict[int, int], symb_durs4)
      _193 = torch.gt(torch.len(symb_durs20), 0)
      _192, symb_durs19 = _193, symb_durs20
    else:
      _192, symb_durs19 = False, symb_durs4
    if _192:
      symb_durs21 = unchecked_cast(Dict[int, int], symb_durs19)
      mel_outputs1 = (self).fx_pauses(mel_outputs, dur_hat, symb_durs21, )
      mel_outputs0 = mel_outputs1
    else:
      mel_outputs0 = mel_outputs
    vocoder = self.vocoder
    audio = (vocoder).forward(mel_outputs0, sr, 0., True, )
    if torch.__isnot__(audio, None):
      audio0 = unchecked_cast(Tensor, audio)
    else:
      ops.prim.RaiseException("AssertionError: ")
      audio0 = _162
    audio1 = torch.detach(audio0)
    audio2 = torch.squeeze(audio1, 1)
    return (audio2, dur_hat)
  def get_support_ids(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    sequence: Tensor,
    symb_durs: Dict[int, int]) -> Optional[List[int]]:
    temp_ids = annotate(List[int], [])
    _194 = torch.keys(symb_durs)
    for _195 in range(torch.len(_194)):
      sid = _194[_195]
      _196 = torch.select(torch.select(sequence, 0, 0), 0, sid)
      comma_ids = self.comma_ids
      _197 = torch.__contains__(comma_ids, annotate(int, _196))
      if _197:
        _198 = torch.append(temp_ids, sid)
      else:
        pass
    if torch.gt(torch.len(temp_ids), 0):
      support_ids : Optional[List[int]] = temp_ids
    else:
      support_ids = None
    return support_ids
  def replace_comma(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    sequence: Tensor,
    support_ids: List[int]) -> Tensor:
    support_sequence = torch.clone(sequence)
    point_id = self.point_id
    _199 = torch.tensor(support_ids, dtype=4)
    _200 = torch.slice(support_sequence)
    _201 = torch.tensor(point_id, dtype=ops.prim.dtype(_200), device=ops.prim.device(_200))
    _202 = annotate(List[Optional[Tensor]], [None, _199])
    _203 = torch.index_put_(_200, _202, _201)
    return support_sequence
  def process_pauses(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    comma_point_durs: Tensor,
    comma_ids: List[int],
    pause_len: int) -> Tensor:
    _204 = torch.tensor(comma_ids, dtype=4)
    _205 = torch.slice(comma_point_durs)
    _206 = annotate(List[Optional[Tensor]], [None, _204])
    _207, _208 = torch.min(torch.index(_205, _206), 1)
    comma_len = torch.item(torch.select(_207, 0, 0))
    point_len = torch.item(torch.select(_207, 0, 1))
    if torch.gt(comma_len, point_len):
      _209 = True
    else:
      _209 = torch.le(pause_len, comma_len)
    if _209:
      final_dur0 = torch.select(comma_point_durs, 0, 0)
      final_dur = final_dur0
    else:
      if torch.ge(pause_len, point_len):
        final_dur2 = torch.select(comma_point_durs, 0, 1)
        final_dur1 = final_dur2
      else:
        point_cf = torch.div(torch.sub(pause_len, comma_len), torch.sub(point_len, comma_len))
        comma_cf = torch.div(torch.sub(point_len, pause_len), torch.sub(point_len, comma_len))
        _210 = torch.select(comma_point_durs, 0, 0)
        _211 = torch.mul(_210, comma_cf)
        _212 = torch.select(comma_point_durs, 0, 1)
        final_dur3 = torch.add(_211, torch.mul(_212, point_cf))
        final_dur1 = final_dur3
      final_dur = final_dur1
    final_dur4 = torch.unsqueeze(final_dur, 0)
    return torch.round(final_dur4)
  def update_pitch_coef(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    norm_pitch: Tensor,
    pitch_coef: Tensor,
    speaker_ids: Tensor) -> Tensor:
    norm_pitch_coefd = torch.mul(norm_pitch, pitch_coef)
    _213 = torch.eq(torch.select(pitch_coef, 0, 0), 0)
    _214 = (torch.where(_213))[0]
    _215 = torch.slice(pitch_coef)
    _216 = torch.tensor(1., dtype=ops.prim.dtype(_215), device=ops.prim.device(_215))
    _217 = annotate(List[Optional[Tensor]], [None, _214])
    _218 = torch.index_put_(_215, _217, _216)
    mean_std_coef = self.mean_std_coef
    _219 = mean_std_coef[int(torch.item(speaker_ids))]
    mean_std_shift = torch.mul(torch.sub(pitch_coef, 1.), _219)
    norm_pitch_shift = torch.add(norm_pitch_coefd, mean_std_shift)
    return norm_pitch_shift
  def fx_pauses(self: __torch__.silero_vocoder.jit_model.MultiTTSModel,
    mel_outputs: Tensor,
    dur_hat: Tensor,
    symb_durs: Dict[int, int]) -> Tensor:
    _220 = torch.keys(symb_durs)
    for _221 in range(torch.len(_220)):
      sid = _220[_221]
      _222 = torch.slice(torch.select(dur_hat, 0, 0), 0, None, sid)
      dur_sum = int(torch.item(torch.sum(_222)))
      _223 = torch.select(torch.select(dur_hat, 0, 0), 0, sid)
      sdur = int(torch.item(_223))
      if torch.gt(sdur, 10):
        sil_value = self.sil_value
        _224 = torch.slice(torch.slice(mel_outputs), 1)
        _225 = torch.slice(_224, 2, torch.add(dur_sum, 10), torch.add(dur_sum, sdur))
        _226 = torch.tensor(sil_value, dtype=ops.prim.dtype(_225), device=ops.prim.device(_225))
        _227 = torch.copy_(_225, _226)
      else:
        sil_value0 = self.sil_value
        _228 = torch.slice(torch.slice(mel_outputs), 1)
        _229 = torch.slice(_228, 2, dur_sum, torch.add(dur_sum, sdur))
        _230 = torch.tensor(sil_value0, dtype=ops.prim.dtype(_229), device=ops.prim.device(_229))
        _231 = torch.copy_(_229, _230)
    return mel_outputs
