class no_grad:
  prev : bool
  def __enter__(self: __torch__.torch.autograd.grad_mode.no_grad) -> NoneType:
    self.prev = torch.is_grad_enabled()
    torch.set_grad_enabled(False)
    return None
  def __exit__(self: __torch__.torch.autograd.grad_mode.no_grad,
    exc_type: Any,
    exc_value: Any,
    traceback: Any) -> NoneType:
    prev = self.prev
    torch.set_grad_enabled(prev)
    return None
  def __init__(self: __torch__.torch.autograd.grad_mode.no_grad) -> NoneType:
    self.prev = False
    return None
