class TransformerSeriesPredictor(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  speaker_emb : str
  embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_166.Embedding
  transformer : __torch__.tacotron2.fastpitch_layers.___torch_mangle_64.ForwardTransformer
  lin : __torch__.torch.nn.modules.linear.___torch_mangle_65.Linear
  speaker_embedding : __torch__.torch.nn.modules.sparse.___torch_mangle_123.Embedding
  def forward(self: __torch__.jit_forward_model.___torch_mangle_167.TransformerSeriesPredictor,
    x: Tensor,
    speaker_ids: Tensor,
    src_pad_mask: Optional[Tensor]=None,
    alpha: float=1.) -> Tensor:
    embedding = self.embedding
    x0 = (embedding).forward(x, )
    seq_len = torch.size(x0, 1)
    speaker_embedding = self.speaker_embedding
    _0 = (speaker_embedding).forward(speaker_ids, )
    speaker_embeds = torch.repeat(torch.unsqueeze(_0, 1), [1, seq_len, 1])
    x1 = torch.add(x0, speaker_embeds)
    transformer = self.transformer
    x2 = (transformer).forward(x1, src_pad_mask, )
    lin = self.lin
    output = (lin).forward(x2, )
    return torch.div(output, alpha)
