class JitGenerator(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  _is_full_backward_hook : Optional[bool]
  mixed_freq : bool
  super_resolution : bool
  num_kernels : int
  num_upsamples : int
  multiband : bool
  N : int
  postprocess : int
  resample : int
  istft : bool
  stride_d : int
  stride : int
  LRELU_SLOPE : float
  sp_embedding : int
  average_24_8 : bool
  pqmf_layer : __torch__.vocoder.hifigan.pqmf.PQMF
  conv_pre : __torch__.torch.nn.modules.container.___torch_mangle_8.ModuleList
  ups : __torch__.torch.nn.modules.container.___torch_mangle_11.ModuleList
  resblocks : __torch__.torch.nn.modules.container.___torch_mangle_48.ModuleList
  ups_u : __torch__.torch.nn.modules.container.___torch_mangle_50.ModuleList
  resblocks_u : __torch__.torch.nn.modules.container.___torch_mangle_51.ModuleList
  conv_post : __torch__.torch.nn.modules.conv.___torch_mangle_52.Conv1d
  conv_post_u : __torch__.torch.nn.modules.conv.___torch_mangle_52.Conv1d
  ups_8 : __torch__.torch.nn.modules.container.___torch_mangle_53.ModuleList
  resblocks_8 : __torch__.torch.nn.modules.container.___torch_mangle_54.ModuleList
  activation_post : __torch__.vocoder.hifigan.generator.SnakeBeta
  activation_ups : __torch__.torch.nn.modules.container.___torch_mangle_55.ModuleList
  activation_ups_8 : __torch__.torch.nn.modules.container.___torch_mangle_56.ModuleList
  pqmf_3 : __torch__.vocoder.hifigan.pqmf.PQMF
  def forward(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor,
    sample_rate: int,
    coef: float=0.,
    inference: bool=True) -> Optional[Tensor]:
    _0 = torch.__contains__([32000, 48000], sample_rate)
    if _0:
      _1 : Optional[Tensor] = (self)._forward_u(x, )
    else:
      if torch.eq(sample_rate, 24000):
        _2 : Optional[Tensor] = (self)._forward_24(x, )
      else:
        if torch.eq(sample_rate, 8000):
          average_24_8 = self.average_24_8
          if torch.__not__(average_24_8):
            _4 = (self)._forward_8(x, )
          else:
            pqmf_3 = self.pqmf_3
            _5 = (pqmf_3).forward((self)._forward_24(x, ), )
            _6 = torch.slice(torch.slice(_5), 1, None, 1)
            _4 = torch.slice(_6, 2)
          _3 : Optional[Tensor] = _4
        else:
          _3 = None
        _2 = _3
      _1 = _2
    return _1
  def _forward_u(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    conv_pre = self.conv_pre
    _1 = getattr(conv_pre, "1")
    x0 = (_1).forward(x, )
    ups_u = self.ups_u
    _0 = getattr(ups_u, "0")
    _10 = getattr(ups_u, "1")
    _2 = getattr(ups_u, "2")
    _3 = getattr(ups_u, "3")
    activation_ups = self.activation_ups
    _00 = getattr(activation_ups, "0")
    _11 = getattr(activation_ups, "1")
    _20 = getattr(activation_ups, "2")
    _30 = getattr(activation_ups, "3")
    x1 = (_0).forward((_00).forward(x0, ), None, )
    resblocks_u = self.resblocks_u
    _01 = getattr(resblocks_u, "0")
    _12 = getattr(resblocks_u, "1")
    _21 = getattr(resblocks_u, "2")
    _31 = getattr(resblocks_u, "3")
    _4 = getattr(resblocks_u, "4")
    _5 = getattr(resblocks_u, "5")
    _6 = getattr(resblocks_u, "6")
    _7 = getattr(resblocks_u, "7")
    _8 = getattr(resblocks_u, "8")
    _9 = getattr(resblocks_u, "9")
    _100 = getattr(resblocks_u, "10")
    _110 = getattr(resblocks_u, "11")
    num_kernels = self.num_kernels
    _13 = torch.le(torch.mul(0, num_kernels), 0)
    if _13:
      num_kernels0 = self.num_kernels
      _15 = torch.lt(0, torch.mul(1, num_kernels0))
      _14 = _15
    else:
      _14 = False
    if _14:
      num_kernels1 = self.num_kernels
      _16 = torch.eq(torch.mul(0, num_kernels1), 0)
      if _16:
        xs0 = (_01).forward(x1, )
      else:
        xs1 = torch.add_(x1, (_01).forward(x1, ))
        xs0 = xs1
      xs = xs0
    else:
      xs = x1
    num_kernels2 = self.num_kernels
    _17 = torch.le(torch.mul(0, num_kernels2), 1)
    if _17:
      num_kernels3 = self.num_kernels
      _19 = torch.lt(1, torch.mul(1, num_kernels3))
      _18 = _19
    else:
      _18 = False
    if _18:
      num_kernels4 = self.num_kernels
      _22 = torch.eq(torch.mul(0, num_kernels4), 1)
      if _22:
        xs3 = (_12).forward(x1, )
      else:
        xs4 = torch.add_(xs, (_12).forward(x1, ))
        xs3 = xs4
      xs2 = xs3
    else:
      xs2 = xs
    num_kernels5 = self.num_kernels
    _23 = torch.le(torch.mul(0, num_kernels5), 2)
    if _23:
      num_kernels6 = self.num_kernels
      _25 = torch.lt(2, torch.mul(1, num_kernels6))
      _24 = _25
    else:
      _24 = False
    if _24:
      num_kernels7 = self.num_kernels
      _26 = torch.eq(torch.mul(0, num_kernels7), 2)
      if _26:
        xs6 = (_21).forward(x1, )
      else:
        xs7 = torch.add_(xs2, (_21).forward(x1, ))
        xs6 = xs7
      xs5 = xs6
    else:
      xs5 = xs2
    num_kernels8 = self.num_kernels
    _27 = torch.le(torch.mul(0, num_kernels8), 3)
    if _27:
      num_kernels9 = self.num_kernels
      _29 = torch.lt(3, torch.mul(1, num_kernels9))
      _28 = _29
    else:
      _28 = False
    if _28:
      num_kernels10 = self.num_kernels
      _32 = torch.eq(torch.mul(0, num_kernels10), 3)
      if _32:
        xs9 = (_31).forward(x1, )
      else:
        xs10 = torch.add_(xs5, (_31).forward(x1, ))
        xs9 = xs10
      xs8 = xs9
    else:
      xs8 = xs5
    num_kernels11 = self.num_kernels
    _33 = torch.le(torch.mul(0, num_kernels11), 4)
    if _33:
      num_kernels12 = self.num_kernels
      _35 = torch.lt(4, torch.mul(1, num_kernels12))
      _34 = _35
    else:
      _34 = False
    if _34:
      num_kernels13 = self.num_kernels
      _36 = torch.eq(torch.mul(0, num_kernels13), 4)
      if _36:
        xs12 = (_4).forward(x1, )
      else:
        xs13 = torch.add_(xs8, (_4).forward(x1, ))
        xs12 = xs13
      xs11 = xs12
    else:
      xs11 = xs8
    num_kernels14 = self.num_kernels
    _37 = torch.le(torch.mul(0, num_kernels14), 5)
    if _37:
      num_kernels15 = self.num_kernels
      _39 = torch.lt(5, torch.mul(1, num_kernels15))
      _38 = _39
    else:
      _38 = False
    if _38:
      num_kernels16 = self.num_kernels
      _40 = torch.eq(torch.mul(0, num_kernels16), 5)
      if _40:
        xs15 = (_5).forward(x1, )
      else:
        xs16 = torch.add_(xs11, (_5).forward(x1, ))
        xs15 = xs16
      xs14 = xs15
    else:
      xs14 = xs11
    num_kernels17 = self.num_kernels
    _41 = torch.le(torch.mul(0, num_kernels17), 6)
    if _41:
      num_kernels18 = self.num_kernels
      _43 = torch.lt(6, torch.mul(1, num_kernels18))
      _42 = _43
    else:
      _42 = False
    if _42:
      num_kernels19 = self.num_kernels
      _44 = torch.eq(torch.mul(0, num_kernels19), 6)
      if _44:
        xs18 = (_6).forward(x1, )
      else:
        xs19 = torch.add_(xs14, (_6).forward(x1, ))
        xs18 = xs19
      xs17 = xs18
    else:
      xs17 = xs14
    num_kernels20 = self.num_kernels
    _45 = torch.le(torch.mul(0, num_kernels20), 7)
    if _45:
      num_kernels21 = self.num_kernels
      _47 = torch.lt(7, torch.mul(1, num_kernels21))
      _46 = _47
    else:
      _46 = False
    if _46:
      num_kernels22 = self.num_kernels
      _48 = torch.eq(torch.mul(0, num_kernels22), 7)
      if _48:
        xs21 = (_7).forward(x1, )
      else:
        xs22 = torch.add_(xs17, (_7).forward(x1, ))
        xs21 = xs22
      xs20 = xs21
    else:
      xs20 = xs17
    num_kernels23 = self.num_kernels
    _49 = torch.le(torch.mul(0, num_kernels23), 8)
    if _49:
      num_kernels24 = self.num_kernels
      _51 = torch.lt(8, torch.mul(1, num_kernels24))
      _50 = _51
    else:
      _50 = False
    if _50:
      num_kernels25 = self.num_kernels
      _52 = torch.eq(torch.mul(0, num_kernels25), 8)
      if _52:
        xs24 = (_8).forward(x1, )
      else:
        xs25 = torch.add_(xs20, (_8).forward(x1, ))
        xs24 = xs25
      xs23 = xs24
    else:
      xs23 = xs20
    num_kernels26 = self.num_kernels
    _53 = torch.le(torch.mul(0, num_kernels26), 9)
    if _53:
      num_kernels27 = self.num_kernels
      _55 = torch.lt(9, torch.mul(1, num_kernels27))
      _54 = _55
    else:
      _54 = False
    if _54:
      num_kernels28 = self.num_kernels
      _56 = torch.eq(torch.mul(0, num_kernels28), 9)
      if _56:
        xs27 = (_9).forward(x1, )
      else:
        xs28 = torch.add_(xs23, (_9).forward(x1, ))
        xs27 = xs28
      xs26 = xs27
    else:
      xs26 = xs23
    num_kernels29 = self.num_kernels
    _57 = torch.le(torch.mul(0, num_kernels29), 10)
    if _57:
      num_kernels30 = self.num_kernels
      _59 = torch.lt(10, torch.mul(1, num_kernels30))
      _58 = _59
    else:
      _58 = False
    if _58:
      num_kernels31 = self.num_kernels
      _60 = torch.eq(torch.mul(0, num_kernels31), 10)
      if _60:
        xs30 = (_100).forward(x1, )
      else:
        xs31 = torch.add_(xs26, (_100).forward(x1, ))
        xs30 = xs31
      xs29 = xs30
    else:
      xs29 = xs26
    num_kernels32 = self.num_kernels
    _61 = torch.le(torch.mul(0, num_kernels32), 11)
    if _61:
      num_kernels33 = self.num_kernels
      _63 = torch.lt(11, torch.mul(1, num_kernels33))
      _62 = _63
    else:
      _62 = False
    if _62:
      num_kernels34 = self.num_kernels
      _64 = torch.eq(torch.mul(0, num_kernels34), 11)
      if _64:
        xs33 = (_110).forward(x1, )
      else:
        xs34 = torch.add_(xs29, (_110).forward(x1, ))
        xs33 = xs34
      xs32 = xs33
    else:
      xs32 = xs29
    num_kernels35 = self.num_kernels
    x2 = torch.div(xs32, num_kernels35)
    x3 = (_10).forward((_11).forward(x2, ), None, )
    resblocks_u0 = self.resblocks_u
    _060 = getattr(resblocks_u0, "0")
    _162 = getattr(resblocks_u0, "1")
    _264 = getattr(resblocks_u0, "2")
    _365 = getattr(resblocks_u0, "3")
    _462 = getattr(resblocks_u0, "4")
    _562 = getattr(resblocks_u0, "5")
    _662 = getattr(resblocks_u0, "6")
    _763 = getattr(resblocks_u0, "7")
    _863 = getattr(resblocks_u0, "8")
    _963 = getattr(resblocks_u0, "9")
    _1062 = getattr(resblocks_u0, "10")
    _1162 = getattr(resblocks_u0, "11")
    num_kernels36 = self.num_kernels
    _65 = torch.le(torch.mul(1, num_kernels36), 0)
    if _65:
      num_kernels37 = self.num_kernels
      _67 = torch.lt(0, torch.mul(2, num_kernels37))
      _66 = _67
    else:
      _66 = False
    if _66:
      num_kernels38 = self.num_kernels
      _68 = torch.eq(torch.mul(1, num_kernels38), 0)
      if _68:
        xs36 = (_060).forward(x3, )
      else:
        xs37 = torch.add_(x3, (_060).forward(x3, ))
        xs36 = xs37
      xs35 = xs36
    else:
      xs35 = x3
    num_kernels39 = self.num_kernels
    _69 = torch.le(torch.mul(1, num_kernels39), 1)
    if _69:
      num_kernels40 = self.num_kernels
      _71 = torch.lt(1, torch.mul(2, num_kernels40))
      _70 = _71
    else:
      _70 = False
    if _70:
      num_kernels41 = self.num_kernels
      _72 = torch.eq(torch.mul(1, num_kernels41), 1)
      if _72:
        xs39 = (_162).forward(x3, )
      else:
        xs40 = torch.add_(xs35, (_162).forward(x3, ))
        xs39 = xs40
      xs38 = xs39
    else:
      xs38 = xs35
    num_kernels42 = self.num_kernels
    _73 = torch.le(torch.mul(1, num_kernels42), 2)
    if _73:
      num_kernels43 = self.num_kernels
      _75 = torch.lt(2, torch.mul(2, num_kernels43))
      _74 = _75
    else:
      _74 = False
    if _74:
      num_kernels44 = self.num_kernels
      _76 = torch.eq(torch.mul(1, num_kernels44), 2)
      if _76:
        xs42 = (_264).forward(x3, )
      else:
        xs43 = torch.add_(xs38, (_264).forward(x3, ))
        xs42 = xs43
      xs41 = xs42
    else:
      xs41 = xs38
    num_kernels45 = self.num_kernels
    _77 = torch.le(torch.mul(1, num_kernels45), 3)
    if _77:
      num_kernels46 = self.num_kernels
      _79 = torch.lt(3, torch.mul(2, num_kernels46))
      _78 = _79
    else:
      _78 = False
    if _78:
      num_kernels47 = self.num_kernels
      _80 = torch.eq(torch.mul(1, num_kernels47), 3)
      if _80:
        xs45 = (_365).forward(x3, )
      else:
        xs46 = torch.add_(xs41, (_365).forward(x3, ))
        xs45 = xs46
      xs44 = xs45
    else:
      xs44 = xs41
    num_kernels48 = self.num_kernels
    _81 = torch.le(torch.mul(1, num_kernels48), 4)
    if _81:
      num_kernels49 = self.num_kernels
      _83 = torch.lt(4, torch.mul(2, num_kernels49))
      _82 = _83
    else:
      _82 = False
    if _82:
      num_kernels50 = self.num_kernels
      _84 = torch.eq(torch.mul(1, num_kernels50), 4)
      if _84:
        xs48 = (_462).forward(x3, )
      else:
        xs49 = torch.add_(xs44, (_462).forward(x3, ))
        xs48 = xs49
      xs47 = xs48
    else:
      xs47 = xs44
    num_kernels51 = self.num_kernels
    _85 = torch.le(torch.mul(1, num_kernels51), 5)
    if _85:
      num_kernels52 = self.num_kernels
      _87 = torch.lt(5, torch.mul(2, num_kernels52))
      _86 = _87
    else:
      _86 = False
    if _86:
      num_kernels53 = self.num_kernels
      _88 = torch.eq(torch.mul(1, num_kernels53), 5)
      if _88:
        xs51 = (_562).forward(x3, )
      else:
        xs52 = torch.add_(xs47, (_562).forward(x3, ))
        xs51 = xs52
      xs50 = xs51
    else:
      xs50 = xs47
    num_kernels54 = self.num_kernels
    _89 = torch.le(torch.mul(1, num_kernels54), 6)
    if _89:
      num_kernels55 = self.num_kernels
      _91 = torch.lt(6, torch.mul(2, num_kernels55))
      _90 = _91
    else:
      _90 = False
    if _90:
      num_kernels56 = self.num_kernels
      _92 = torch.eq(torch.mul(1, num_kernels56), 6)
      if _92:
        xs54 = (_662).forward(x3, )
      else:
        xs55 = torch.add_(xs50, (_662).forward(x3, ))
        xs54 = xs55
      xs53 = xs54
    else:
      xs53 = xs50
    num_kernels57 = self.num_kernels
    _93 = torch.le(torch.mul(1, num_kernels57), 7)
    if _93:
      num_kernels58 = self.num_kernels
      _95 = torch.lt(7, torch.mul(2, num_kernels58))
      _94 = _95
    else:
      _94 = False
    if _94:
      num_kernels59 = self.num_kernels
      _96 = torch.eq(torch.mul(1, num_kernels59), 7)
      if _96:
        xs57 = (_763).forward(x3, )
      else:
        xs58 = torch.add_(xs53, (_763).forward(x3, ))
        xs57 = xs58
      xs56 = xs57
    else:
      xs56 = xs53
    num_kernels60 = self.num_kernels
    _97 = torch.le(torch.mul(1, num_kernels60), 8)
    if _97:
      num_kernels61 = self.num_kernels
      _99 = torch.lt(8, torch.mul(2, num_kernels61))
      _98 = _99
    else:
      _98 = False
    if _98:
      num_kernels62 = self.num_kernels
      _101 = torch.eq(torch.mul(1, num_kernels62), 8)
      if _101:
        xs60 = (_863).forward(x3, )
      else:
        xs61 = torch.add_(xs56, (_863).forward(x3, ))
        xs60 = xs61
      xs59 = xs60
    else:
      xs59 = xs56
    num_kernels63 = self.num_kernels
    _102 = torch.le(torch.mul(1, num_kernels63), 9)
    if _102:
      num_kernels64 = self.num_kernels
      _104 = torch.lt(9, torch.mul(2, num_kernels64))
      _103 = _104
    else:
      _103 = False
    if _103:
      num_kernels65 = self.num_kernels
      _105 = torch.eq(torch.mul(1, num_kernels65), 9)
      if _105:
        xs63 = (_963).forward(x3, )
      else:
        xs64 = torch.add_(xs59, (_963).forward(x3, ))
        xs63 = xs64
      xs62 = xs63
    else:
      xs62 = xs59
    num_kernels66 = self.num_kernels
    _106 = torch.le(torch.mul(1, num_kernels66), 10)
    if _106:
      num_kernels67 = self.num_kernels
      _108 = torch.lt(10, torch.mul(2, num_kernels67))
      _107 = _108
    else:
      _107 = False
    if _107:
      num_kernels68 = self.num_kernels
      _109 = torch.eq(torch.mul(1, num_kernels68), 10)
      if _109:
        xs66 = (_1062).forward(x3, )
      else:
        xs67 = torch.add_(xs62, (_1062).forward(x3, ))
        xs66 = xs67
      xs65 = xs66
    else:
      xs65 = xs62
    num_kernels69 = self.num_kernels
    _111 = torch.le(torch.mul(1, num_kernels69), 11)
    if _111:
      num_kernels70 = self.num_kernels
      _113 = torch.lt(11, torch.mul(2, num_kernels70))
      _112 = _113
    else:
      _112 = False
    if _112:
      num_kernels71 = self.num_kernels
      _114 = torch.eq(torch.mul(1, num_kernels71), 11)
      if _114:
        xs69 = (_1162).forward(x3, )
      else:
        xs70 = torch.add_(xs65, (_1162).forward(x3, ))
        xs69 = xs70
      xs68 = xs69
    else:
      xs68 = xs65
    num_kernels72 = self.num_kernels
    x4 = torch.div(xs68, num_kernels72)
    x5 = (_2).forward((_20).forward(x4, ), None, )
    resblocks_u1 = self.resblocks_u
    _0111 = getattr(resblocks_u1, "0")
    _1112 = getattr(resblocks_u1, "1")
    _2114 = getattr(resblocks_u1, "2")
    _3115 = getattr(resblocks_u1, "3")
    _4112 = getattr(resblocks_u1, "4")
    _5112 = getattr(resblocks_u1, "5")
    _6110 = getattr(resblocks_u1, "6")
    _7109 = getattr(resblocks_u1, "7")
    _8107 = getattr(resblocks_u1, "8")
    _9105 = getattr(resblocks_u1, "9")
    _10104 = getattr(resblocks_u1, "10")
    _1166 = getattr(resblocks_u1, "11")
    num_kernels73 = self.num_kernels
    _115 = torch.le(torch.mul(2, num_kernels73), 0)
    if _115:
      num_kernels74 = self.num_kernels
      _117 = torch.lt(0, torch.mul(3, num_kernels74))
      _116 = _117
    else:
      _116 = False
    if _116:
      num_kernels75 = self.num_kernels
      _118 = torch.eq(torch.mul(2, num_kernels75), 0)
      if _118:
        xs72 = (_0111).forward(x5, )
      else:
        xs73 = torch.add_(x5, (_0111).forward(x5, ))
        xs72 = xs73
      xs71 = xs72
    else:
      xs71 = x5
    num_kernels76 = self.num_kernels
    _119 = torch.le(torch.mul(2, num_kernels76), 1)
    if _119:
      num_kernels77 = self.num_kernels
      _121 = torch.lt(1, torch.mul(3, num_kernels77))
      _120 = _121
    else:
      _120 = False
    if _120:
      num_kernels78 = self.num_kernels
      _122 = torch.eq(torch.mul(2, num_kernels78), 1)
      if _122:
        xs75 = (_1112).forward(x5, )
      else:
        xs76 = torch.add_(xs71, (_1112).forward(x5, ))
        xs75 = xs76
      xs74 = xs75
    else:
      xs74 = xs71
    num_kernels79 = self.num_kernels
    _123 = torch.le(torch.mul(2, num_kernels79), 2)
    if _123:
      num_kernels80 = self.num_kernels
      _125 = torch.lt(2, torch.mul(3, num_kernels80))
      _124 = _125
    else:
      _124 = False
    if _124:
      num_kernels81 = self.num_kernels
      _126 = torch.eq(torch.mul(2, num_kernels81), 2)
      if _126:
        xs78 = (_2114).forward(x5, )
      else:
        xs79 = torch.add_(xs74, (_2114).forward(x5, ))
        xs78 = xs79
      xs77 = xs78
    else:
      xs77 = xs74
    num_kernels82 = self.num_kernels
    _127 = torch.le(torch.mul(2, num_kernels82), 3)
    if _127:
      num_kernels83 = self.num_kernels
      _129 = torch.lt(3, torch.mul(3, num_kernels83))
      _128 = _129
    else:
      _128 = False
    if _128:
      num_kernels84 = self.num_kernels
      _130 = torch.eq(torch.mul(2, num_kernels84), 3)
      if _130:
        xs81 = (_3115).forward(x5, )
      else:
        xs82 = torch.add_(xs77, (_3115).forward(x5, ))
        xs81 = xs82
      xs80 = xs81
    else:
      xs80 = xs77
    num_kernels85 = self.num_kernels
    _131 = torch.le(torch.mul(2, num_kernels85), 4)
    if _131:
      num_kernels86 = self.num_kernels
      _133 = torch.lt(4, torch.mul(3, num_kernels86))
      _132 = _133
    else:
      _132 = False
    if _132:
      num_kernels87 = self.num_kernels
      _134 = torch.eq(torch.mul(2, num_kernels87), 4)
      if _134:
        xs84 = (_4112).forward(x5, )
      else:
        xs85 = torch.add_(xs80, (_4112).forward(x5, ))
        xs84 = xs85
      xs83 = xs84
    else:
      xs83 = xs80
    num_kernels88 = self.num_kernels
    _135 = torch.le(torch.mul(2, num_kernels88), 5)
    if _135:
      num_kernels89 = self.num_kernels
      _137 = torch.lt(5, torch.mul(3, num_kernels89))
      _136 = _137
    else:
      _136 = False
    if _136:
      num_kernels90 = self.num_kernels
      _138 = torch.eq(torch.mul(2, num_kernels90), 5)
      if _138:
        xs87 = (_5112).forward(x5, )
      else:
        xs88 = torch.add_(xs83, (_5112).forward(x5, ))
        xs87 = xs88
      xs86 = xs87
    else:
      xs86 = xs83
    num_kernels91 = self.num_kernels
    _139 = torch.le(torch.mul(2, num_kernels91), 6)
    if _139:
      num_kernels92 = self.num_kernels
      _141 = torch.lt(6, torch.mul(3, num_kernels92))
      _140 = _141
    else:
      _140 = False
    if _140:
      num_kernels93 = self.num_kernels
      _142 = torch.eq(torch.mul(2, num_kernels93), 6)
      if _142:
        xs90 = (_6110).forward(x5, )
      else:
        xs91 = torch.add_(xs86, (_6110).forward(x5, ))
        xs90 = xs91
      xs89 = xs90
    else:
      xs89 = xs86
    num_kernels94 = self.num_kernels
    _143 = torch.le(torch.mul(2, num_kernels94), 7)
    if _143:
      num_kernels95 = self.num_kernels
      _145 = torch.lt(7, torch.mul(3, num_kernels95))
      _144 = _145
    else:
      _144 = False
    if _144:
      num_kernels96 = self.num_kernels
      _146 = torch.eq(torch.mul(2, num_kernels96), 7)
      if _146:
        xs93 = (_7109).forward(x5, )
      else:
        xs94 = torch.add_(xs89, (_7109).forward(x5, ))
        xs93 = xs94
      xs92 = xs93
    else:
      xs92 = xs89
    num_kernels97 = self.num_kernels
    _147 = torch.le(torch.mul(2, num_kernels97), 8)
    if _147:
      num_kernels98 = self.num_kernels
      _149 = torch.lt(8, torch.mul(3, num_kernels98))
      _148 = _149
    else:
      _148 = False
    if _148:
      num_kernels99 = self.num_kernels
      _150 = torch.eq(torch.mul(2, num_kernels99), 8)
      if _150:
        xs96 = (_8107).forward(x5, )
      else:
        xs97 = torch.add_(xs92, (_8107).forward(x5, ))
        xs96 = xs97
      xs95 = xs96
    else:
      xs95 = xs92
    num_kernels100 = self.num_kernels
    _151 = torch.le(torch.mul(2, num_kernels100), 9)
    if _151:
      num_kernels101 = self.num_kernels
      _153 = torch.lt(9, torch.mul(3, num_kernels101))
      _152 = _153
    else:
      _152 = False
    if _152:
      num_kernels102 = self.num_kernels
      _154 = torch.eq(torch.mul(2, num_kernels102), 9)
      if _154:
        xs99 = (_9105).forward(x5, )
      else:
        xs100 = torch.add_(xs95, (_9105).forward(x5, ))
        xs99 = xs100
      xs98 = xs99
    else:
      xs98 = xs95
    num_kernels103 = self.num_kernels
    _155 = torch.le(torch.mul(2, num_kernels103), 10)
    if _155:
      num_kernels104 = self.num_kernels
      _157 = torch.lt(10, torch.mul(3, num_kernels104))
      _156 = _157
    else:
      _156 = False
    if _156:
      num_kernels105 = self.num_kernels
      _158 = torch.eq(torch.mul(2, num_kernels105), 10)
      if _158:
        xs102 = (_10104).forward(x5, )
      else:
        xs103 = torch.add_(xs98, (_10104).forward(x5, ))
        xs102 = xs103
      xs101 = xs102
    else:
      xs101 = xs98
    num_kernels106 = self.num_kernels
    _159 = torch.le(torch.mul(2, num_kernels106), 11)
    if _159:
      num_kernels107 = self.num_kernels
      _161 = torch.lt(11, torch.mul(3, num_kernels107))
      _160 = _161
    else:
      _160 = False
    if _160:
      num_kernels108 = self.num_kernels
      _163 = torch.eq(torch.mul(2, num_kernels108), 11)
      if _163:
        xs105 = (_1166).forward(x5, )
      else:
        xs106 = torch.add_(xs101, (_1166).forward(x5, ))
        xs105 = xs106
      xs104 = xs105
    else:
      xs104 = xs101
    num_kernels109 = self.num_kernels
    x6 = torch.div(xs104, num_kernels109)
    x7 = (_3).forward((_30).forward(x6, ), None, )
    resblocks_u2 = self.resblocks_u
    _0161 = getattr(resblocks_u2, "0")
    _1106 = getattr(resblocks_u2, "1")
    _2164 = getattr(resblocks_u2, "2")
    _3161 = getattr(resblocks_u2, "3")
    _4157 = getattr(resblocks_u2, "4")
    _5155 = getattr(resblocks_u2, "5")
    _6153 = getattr(resblocks_u2, "6")
    _7152 = getattr(resblocks_u2, "7")
    _8115 = getattr(resblocks_u2, "8")
    _9110 = getattr(resblocks_u2, "9")
    _10107 = getattr(resblocks_u2, "10")
    _1167 = getattr(resblocks_u2, "11")
    num_kernels110 = self.num_kernels
    _165 = torch.le(torch.mul(3, num_kernels110), 0)
    if _165:
      num_kernels111 = self.num_kernels
      _166 = torch.lt(0, torch.mul(4, num_kernels111))
      _164 = _166
    else:
      _164 = False
    if _164:
      num_kernels112 = self.num_kernels
      _167 = torch.eq(torch.mul(3, num_kernels112), 0)
      if _167:
        xs108 = (_0161).forward(x7, )
      else:
        xs109 = torch.add_(x7, (_0161).forward(x7, ))
        xs108 = xs109
      xs107 = xs108
    else:
      xs107 = x7
    num_kernels113 = self.num_kernels
    _168 = torch.le(torch.mul(3, num_kernels113), 1)
    if _168:
      num_kernels114 = self.num_kernels
      _170 = torch.lt(1, torch.mul(4, num_kernels114))
      _169 = _170
    else:
      _169 = False
    if _169:
      num_kernels115 = self.num_kernels
      _171 = torch.eq(torch.mul(3, num_kernels115), 1)
      if _171:
        xs111 = (_1106).forward(x7, )
      else:
        xs112 = torch.add_(xs107, (_1106).forward(x7, ))
        xs111 = xs112
      xs110 = xs111
    else:
      xs110 = xs107
    num_kernels116 = self.num_kernels
    _172 = torch.le(torch.mul(3, num_kernels116), 2)
    if _172:
      num_kernels117 = self.num_kernels
      _174 = torch.lt(2, torch.mul(4, num_kernels117))
      _173 = _174
    else:
      _173 = False
    if _173:
      num_kernels118 = self.num_kernels
      _175 = torch.eq(torch.mul(3, num_kernels118), 2)
      if _175:
        xs114 = (_2164).forward(x7, )
      else:
        xs115 = torch.add_(xs110, (_2164).forward(x7, ))
        xs114 = xs115
      xs113 = xs114
    else:
      xs113 = xs110
    num_kernels119 = self.num_kernels
    _176 = torch.le(torch.mul(3, num_kernels119), 3)
    if _176:
      num_kernels120 = self.num_kernels
      _178 = torch.lt(3, torch.mul(4, num_kernels120))
      _177 = _178
    else:
      _177 = False
    if _177:
      num_kernels121 = self.num_kernels
      _179 = torch.eq(torch.mul(3, num_kernels121), 3)
      if _179:
        xs117 = (_3161).forward(x7, )
      else:
        xs118 = torch.add_(xs113, (_3161).forward(x7, ))
        xs117 = xs118
      xs116 = xs117
    else:
      xs116 = xs113
    num_kernels122 = self.num_kernels
    _180 = torch.le(torch.mul(3, num_kernels122), 4)
    if _180:
      num_kernels123 = self.num_kernels
      _182 = torch.lt(4, torch.mul(4, num_kernels123))
      _181 = _182
    else:
      _181 = False
    if _181:
      num_kernels124 = self.num_kernels
      _183 = torch.eq(torch.mul(3, num_kernels124), 4)
      if _183:
        xs120 = (_4157).forward(x7, )
      else:
        xs121 = torch.add_(xs116, (_4157).forward(x7, ))
        xs120 = xs121
      xs119 = xs120
    else:
      xs119 = xs116
    num_kernels125 = self.num_kernels
    _184 = torch.le(torch.mul(3, num_kernels125), 5)
    if _184:
      num_kernels126 = self.num_kernels
      _186 = torch.lt(5, torch.mul(4, num_kernels126))
      _185 = _186
    else:
      _185 = False
    if _185:
      num_kernels127 = self.num_kernels
      _187 = torch.eq(torch.mul(3, num_kernels127), 5)
      if _187:
        xs123 = (_5155).forward(x7, )
      else:
        xs124 = torch.add_(xs119, (_5155).forward(x7, ))
        xs123 = xs124
      xs122 = xs123
    else:
      xs122 = xs119
    num_kernels128 = self.num_kernels
    _188 = torch.le(torch.mul(3, num_kernels128), 6)
    if _188:
      num_kernels129 = self.num_kernels
      _190 = torch.lt(6, torch.mul(4, num_kernels129))
      _189 = _190
    else:
      _189 = False
    if _189:
      num_kernels130 = self.num_kernels
      _191 = torch.eq(torch.mul(3, num_kernels130), 6)
      if _191:
        xs126 = (_6153).forward(x7, )
      else:
        xs127 = torch.add_(xs122, (_6153).forward(x7, ))
        xs126 = xs127
      xs125 = xs126
    else:
      xs125 = xs122
    num_kernels131 = self.num_kernels
    _192 = torch.le(torch.mul(3, num_kernels131), 7)
    if _192:
      num_kernels132 = self.num_kernels
      _194 = torch.lt(7, torch.mul(4, num_kernels132))
      _193 = _194
    else:
      _193 = False
    if _193:
      num_kernels133 = self.num_kernels
      _195 = torch.eq(torch.mul(3, num_kernels133), 7)
      if _195:
        xs129 = (_7152).forward(x7, )
      else:
        xs130 = torch.add_(xs125, (_7152).forward(x7, ))
        xs129 = xs130
      xs128 = xs129
    else:
      xs128 = xs125
    num_kernels134 = self.num_kernels
    _196 = torch.le(torch.mul(3, num_kernels134), 8)
    if _196:
      num_kernels135 = self.num_kernels
      _198 = torch.lt(8, torch.mul(4, num_kernels135))
      _197 = _198
    else:
      _197 = False
    if _197:
      num_kernels136 = self.num_kernels
      _199 = torch.eq(torch.mul(3, num_kernels136), 8)
      if _199:
        xs132 = (_8115).forward(x7, )
      else:
        xs133 = torch.add_(xs128, (_8115).forward(x7, ))
        xs132 = xs133
      xs131 = xs132
    else:
      xs131 = xs128
    num_kernels137 = self.num_kernels
    _200 = torch.le(torch.mul(3, num_kernels137), 9)
    if _200:
      num_kernels138 = self.num_kernels
      _202 = torch.lt(9, torch.mul(4, num_kernels138))
      _201 = _202
    else:
      _201 = False
    if _201:
      num_kernels139 = self.num_kernels
      _203 = torch.eq(torch.mul(3, num_kernels139), 9)
      if _203:
        xs135 = (_9110).forward(x7, )
      else:
        xs136 = torch.add_(xs131, (_9110).forward(x7, ))
        xs135 = xs136
      xs134 = xs135
    else:
      xs134 = xs131
    num_kernels140 = self.num_kernels
    _204 = torch.le(torch.mul(3, num_kernels140), 10)
    if _204:
      num_kernels141 = self.num_kernels
      _206 = torch.lt(10, torch.mul(4, num_kernels141))
      _205 = _206
    else:
      _205 = False
    if _205:
      num_kernels142 = self.num_kernels
      _207 = torch.eq(torch.mul(3, num_kernels142), 10)
      if _207:
        xs138 = (_10107).forward(x7, )
      else:
        xs139 = torch.add_(xs134, (_10107).forward(x7, ))
        xs138 = xs139
      xs137 = xs138
    else:
      xs137 = xs134
    num_kernels143 = self.num_kernels
    _208 = torch.le(torch.mul(3, num_kernels143), 11)
    if _208:
      num_kernels144 = self.num_kernels
      _210 = torch.lt(11, torch.mul(4, num_kernels144))
      _209 = _210
    else:
      _209 = False
    if _209:
      num_kernels145 = self.num_kernels
      _211 = torch.eq(torch.mul(3, num_kernels145), 11)
      if _211:
        xs141 = (_1167).forward(x7, )
      else:
        xs142 = torch.add_(xs137, (_1167).forward(x7, ))
        xs141 = xs142
      xs140 = xs141
    else:
      xs140 = xs137
    num_kernels146 = self.num_kernels
    x8 = torch.div(xs140, num_kernels146)
    activation_post = self.activation_post
    x9 = (activation_post).forward(x8, )
    conv_post_u = self.conv_post_u
    x10 = (conv_post_u).forward(x9, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _212 = torch.tanh(x10)
    else:
      _212 = (self).pqmf_synthesis(x10, )
    return _212
  def pqmf_synthesis(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    pqmf_layer = self.pqmf_layer
    resample = self.resample
    _200 = (pqmf_layer).synthesis(x, resample, )
    return _200
  def _forward_24(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    conv_pre = self.conv_pre
    _1 = getattr(conv_pre, "1")
    x11 = (_1).forward(x, )
    ups = self.ups
    _0 = getattr(ups, "0")
    _1213 = getattr(ups, "1")
    _2 = getattr(ups, "2")
    activation_ups = self.activation_ups
    _0211 = getattr(activation_ups, "0")
    _1214 = getattr(activation_ups, "1")
    _2212 = getattr(activation_ups, "2")
    x12 = (_0).forward((_0211).forward(x11, ), None, )
    resblocks = self.resblocks
    _0212 = getattr(resblocks, "0")
    _1215 = getattr(resblocks, "1")
    _2213 = getattr(resblocks, "2")
    _3 = getattr(resblocks, "3")
    _4 = getattr(resblocks, "4")
    _5 = getattr(resblocks, "5")
    _6 = getattr(resblocks, "6")
    _7 = getattr(resblocks, "7")
    _8 = getattr(resblocks, "8")
    num_kernels = self.num_kernels
    _201 = torch.le(torch.mul(0, num_kernels), 0)
    if _201:
      num_kernels147 = self.num_kernels
      _203 = torch.lt(0, torch.mul(1, num_kernels147))
      _202 = _203
    else:
      _202 = False
    if _202:
      num_kernels148 = self.num_kernels
      _204 = torch.eq(torch.mul(0, num_kernels148), 0)
      if _204:
        xs143 = (_0212).forward(x12, )
      else:
        xs144 = torch.add_(x12, (_0212).forward(x12, ))
        xs143 = xs144
      xs = xs143
    else:
      xs = x12
    num_kernels149 = self.num_kernels
    _205 = torch.le(torch.mul(0, num_kernels149), 1)
    if _205:
      num_kernels150 = self.num_kernels
      _207 = torch.lt(1, torch.mul(1, num_kernels150))
      _206 = _207
    else:
      _206 = False
    if _206:
      num_kernels151 = self.num_kernels
      _208 = torch.eq(torch.mul(0, num_kernels151), 1)
      if _208:
        xs146 = (_1215).forward(x12, )
      else:
        xs147 = torch.add_(xs, (_1215).forward(x12, ))
        xs146 = xs147
      xs145 = xs146
    else:
      xs145 = xs
    num_kernels152 = self.num_kernels
    _209 = torch.le(torch.mul(0, num_kernels152), 2)
    if _209:
      num_kernels153 = self.num_kernels
      _211 = torch.lt(2, torch.mul(1, num_kernels153))
      _210 = _211
    else:
      _210 = False
    if _210:
      num_kernels154 = self.num_kernels
      _212 = torch.eq(torch.mul(0, num_kernels154), 2)
      if _212:
        xs149 = (_2213).forward(x12, )
      else:
        xs150 = torch.add_(xs145, (_2213).forward(x12, ))
        xs149 = xs150
      xs148 = xs149
    else:
      xs148 = xs145
    num_kernels155 = self.num_kernels
    _213 = torch.le(torch.mul(0, num_kernels155), 3)
    if _213:
      num_kernels156 = self.num_kernels
      _215 = torch.lt(3, torch.mul(1, num_kernels156))
      _214 = _215
    else:
      _214 = False
    if _214:
      num_kernels157 = self.num_kernels
      _216 = torch.eq(torch.mul(0, num_kernels157), 3)
      if _216:
        xs152 = (_3).forward(x12, )
      else:
        xs153 = torch.add_(xs148, (_3).forward(x12, ))
        xs152 = xs153
      xs151 = xs152
    else:
      xs151 = xs148
    num_kernels158 = self.num_kernels
    _217 = torch.le(torch.mul(0, num_kernels158), 4)
    if _217:
      num_kernels159 = self.num_kernels
      _219 = torch.lt(4, torch.mul(1, num_kernels159))
      _218 = _219
    else:
      _218 = False
    if _218:
      num_kernels160 = self.num_kernels
      _220 = torch.eq(torch.mul(0, num_kernels160), 4)
      if _220:
        xs155 = (_4).forward(x12, )
      else:
        xs156 = torch.add_(xs151, (_4).forward(x12, ))
        xs155 = xs156
      xs154 = xs155
    else:
      xs154 = xs151
    num_kernels161 = self.num_kernels
    _221 = torch.le(torch.mul(0, num_kernels161), 5)
    if _221:
      num_kernels162 = self.num_kernels
      _223 = torch.lt(5, torch.mul(1, num_kernels162))
      _222 = _223
    else:
      _222 = False
    if _222:
      num_kernels163 = self.num_kernels
      _224 = torch.eq(torch.mul(0, num_kernels163), 5)
      if _224:
        xs158 = (_5).forward(x12, )
      else:
        xs159 = torch.add_(xs154, (_5).forward(x12, ))
        xs158 = xs159
      xs157 = xs158
    else:
      xs157 = xs154
    num_kernels164 = self.num_kernels
    _225 = torch.le(torch.mul(0, num_kernels164), 6)
    if _225:
      num_kernels165 = self.num_kernels
      _227 = torch.lt(6, torch.mul(1, num_kernels165))
      _226 = _227
    else:
      _226 = False
    if _226:
      num_kernels166 = self.num_kernels
      _228 = torch.eq(torch.mul(0, num_kernels166), 6)
      if _228:
        xs161 = (_6).forward(x12, )
      else:
        xs162 = torch.add_(xs157, (_6).forward(x12, ))
        xs161 = xs162
      xs160 = xs161
    else:
      xs160 = xs157
    num_kernels167 = self.num_kernels
    _229 = torch.le(torch.mul(0, num_kernels167), 7)
    if _229:
      num_kernels168 = self.num_kernels
      _231 = torch.lt(7, torch.mul(1, num_kernels168))
      _230 = _231
    else:
      _230 = False
    if _230:
      num_kernels169 = self.num_kernels
      _232 = torch.eq(torch.mul(0, num_kernels169), 7)
      if _232:
        xs164 = (_7).forward(x12, )
      else:
        xs165 = torch.add_(xs160, (_7).forward(x12, ))
        xs164 = xs165
      xs163 = xs164
    else:
      xs163 = xs160
    num_kernels170 = self.num_kernels
    _233 = torch.le(torch.mul(0, num_kernels170), 8)
    if _233:
      num_kernels171 = self.num_kernels
      _235 = torch.lt(8, torch.mul(1, num_kernels171))
      _234 = _235
    else:
      _234 = False
    if _234:
      num_kernels172 = self.num_kernels
      _236 = torch.eq(torch.mul(0, num_kernels172), 8)
      if _236:
        xs167 = (_8).forward(x12, )
      else:
        xs168 = torch.add_(xs163, (_8).forward(x12, ))
        xs167 = xs168
      xs166 = xs167
    else:
      xs166 = xs163
    num_kernels173 = self.num_kernels
    x13 = torch.div(xs166, num_kernels173)
    x14 = (_1213).forward((_1214).forward(x13, ), None, )
    resblocks0 = self.resblocks
    _0213 = getattr(resblocks0, "0")
    _1216 = getattr(resblocks0, "1")
    _2214 = getattr(resblocks0, "2")
    _3208 = getattr(resblocks0, "3")
    _4203 = getattr(resblocks0, "4")
    _5201 = getattr(resblocks0, "5")
    _6158 = getattr(resblocks0, "6")
    _7154 = getattr(resblocks0, "7")
    _8116 = getattr(resblocks0, "8")
    num_kernels174 = self.num_kernels
    _237 = torch.le(torch.mul(1, num_kernels174), 0)
    if _237:
      num_kernels175 = self.num_kernels
      _239 = torch.lt(0, torch.mul(2, num_kernels175))
      _238 = _239
    else:
      _238 = False
    if _238:
      num_kernels176 = self.num_kernels
      _240 = torch.eq(torch.mul(1, num_kernels176), 0)
      if _240:
        xs170 = (_0213).forward(x14, )
      else:
        xs171 = torch.add_(x14, (_0213).forward(x14, ))
        xs170 = xs171
      xs169 = xs170
    else:
      xs169 = x14
    num_kernels177 = self.num_kernels
    _241 = torch.le(torch.mul(1, num_kernels177), 1)
    if _241:
      num_kernels178 = self.num_kernels
      _243 = torch.lt(1, torch.mul(2, num_kernels178))
      _242 = _243
    else:
      _242 = False
    if _242:
      num_kernels179 = self.num_kernels
      _244 = torch.eq(torch.mul(1, num_kernels179), 1)
      if _244:
        xs173 = (_1216).forward(x14, )
      else:
        xs174 = torch.add_(xs169, (_1216).forward(x14, ))
        xs173 = xs174
      xs172 = xs173
    else:
      xs172 = xs169
    num_kernels180 = self.num_kernels
    _245 = torch.le(torch.mul(1, num_kernels180), 2)
    if _245:
      num_kernels181 = self.num_kernels
      _247 = torch.lt(2, torch.mul(2, num_kernels181))
      _246 = _247
    else:
      _246 = False
    if _246:
      num_kernels182 = self.num_kernels
      _248 = torch.eq(torch.mul(1, num_kernels182), 2)
      if _248:
        xs176 = (_2214).forward(x14, )
      else:
        xs177 = torch.add_(xs172, (_2214).forward(x14, ))
        xs176 = xs177
      xs175 = xs176
    else:
      xs175 = xs172
    num_kernels183 = self.num_kernels
    _249 = torch.le(torch.mul(1, num_kernels183), 3)
    if _249:
      num_kernels184 = self.num_kernels
      _251 = torch.lt(3, torch.mul(2, num_kernels184))
      _250 = _251
    else:
      _250 = False
    if _250:
      num_kernels185 = self.num_kernels
      _252 = torch.eq(torch.mul(1, num_kernels185), 3)
      if _252:
        xs179 = (_3208).forward(x14, )
      else:
        xs180 = torch.add_(xs175, (_3208).forward(x14, ))
        xs179 = xs180
      xs178 = xs179
    else:
      xs178 = xs175
    num_kernels186 = self.num_kernels
    _253 = torch.le(torch.mul(1, num_kernels186), 4)
    if _253:
      num_kernels187 = self.num_kernels
      _255 = torch.lt(4, torch.mul(2, num_kernels187))
      _254 = _255
    else:
      _254 = False
    if _254:
      num_kernels188 = self.num_kernels
      _256 = torch.eq(torch.mul(1, num_kernels188), 4)
      if _256:
        xs182 = (_4203).forward(x14, )
      else:
        xs183 = torch.add_(xs178, (_4203).forward(x14, ))
        xs182 = xs183
      xs181 = xs182
    else:
      xs181 = xs178
    num_kernels189 = self.num_kernels
    _257 = torch.le(torch.mul(1, num_kernels189), 5)
    if _257:
      num_kernels190 = self.num_kernels
      _259 = torch.lt(5, torch.mul(2, num_kernels190))
      _258 = _259
    else:
      _258 = False
    if _258:
      num_kernels191 = self.num_kernels
      _260 = torch.eq(torch.mul(1, num_kernels191), 5)
      if _260:
        xs185 = (_5201).forward(x14, )
      else:
        xs186 = torch.add_(xs181, (_5201).forward(x14, ))
        xs185 = xs186
      xs184 = xs185
    else:
      xs184 = xs181
    num_kernels192 = self.num_kernels
    _261 = torch.le(torch.mul(1, num_kernels192), 6)
    if _261:
      num_kernels193 = self.num_kernels
      _263 = torch.lt(6, torch.mul(2, num_kernels193))
      _262 = _263
    else:
      _262 = False
    if _262:
      num_kernels194 = self.num_kernels
      _264 = torch.eq(torch.mul(1, num_kernels194), 6)
      if _264:
        xs188 = (_6158).forward(x14, )
      else:
        xs189 = torch.add_(xs184, (_6158).forward(x14, ))
        xs188 = xs189
      xs187 = xs188
    else:
      xs187 = xs184
    num_kernels195 = self.num_kernels
    _265 = torch.le(torch.mul(1, num_kernels195), 7)
    if _265:
      num_kernels196 = self.num_kernels
      _267 = torch.lt(7, torch.mul(2, num_kernels196))
      _266 = _267
    else:
      _266 = False
    if _266:
      num_kernels197 = self.num_kernels
      _268 = torch.eq(torch.mul(1, num_kernels197), 7)
      if _268:
        xs191 = (_7154).forward(x14, )
      else:
        xs192 = torch.add_(xs187, (_7154).forward(x14, ))
        xs191 = xs192
      xs190 = xs191
    else:
      xs190 = xs187
    num_kernels198 = self.num_kernels
    _269 = torch.le(torch.mul(1, num_kernels198), 8)
    if _269:
      num_kernels199 = self.num_kernels
      _271 = torch.lt(8, torch.mul(2, num_kernels199))
      _270 = _271
    else:
      _270 = False
    if _270:
      num_kernels200 = self.num_kernels
      _272 = torch.eq(torch.mul(1, num_kernels200), 8)
      if _272:
        xs194 = (_8116).forward(x14, )
      else:
        xs195 = torch.add_(xs190, (_8116).forward(x14, ))
        xs194 = xs195
      xs193 = xs194
    else:
      xs193 = xs190
    num_kernels201 = self.num_kernels
    x15 = torch.div(xs193, num_kernels201)
    x16 = (_2).forward((_2212).forward(x15, ), None, )
    resblocks1 = self.resblocks
    _0214 = getattr(resblocks1, "0")
    _1217 = getattr(resblocks1, "1")
    _2215 = getattr(resblocks1, "2")
    _3209 = getattr(resblocks1, "3")
    _4204 = getattr(resblocks1, "4")
    _5202 = getattr(resblocks1, "5")
    _6159 = getattr(resblocks1, "6")
    _7155 = getattr(resblocks1, "7")
    _8117 = getattr(resblocks1, "8")
    num_kernels202 = self.num_kernels
    _273 = torch.le(torch.mul(2, num_kernels202), 0)
    if _273:
      num_kernels203 = self.num_kernels
      _275 = torch.lt(0, torch.mul(3, num_kernels203))
      _274 = _275
    else:
      _274 = False
    if _274:
      num_kernels204 = self.num_kernels
      _276 = torch.eq(torch.mul(2, num_kernels204), 0)
      if _276:
        xs197 = (_0214).forward(x16, )
      else:
        xs198 = torch.add_(x16, (_0214).forward(x16, ))
        xs197 = xs198
      xs196 = xs197
    else:
      xs196 = x16
    num_kernels205 = self.num_kernels
    _277 = torch.le(torch.mul(2, num_kernels205), 1)
    if _277:
      num_kernels206 = self.num_kernels
      _279 = torch.lt(1, torch.mul(3, num_kernels206))
      _278 = _279
    else:
      _278 = False
    if _278:
      num_kernels207 = self.num_kernels
      _280 = torch.eq(torch.mul(2, num_kernels207), 1)
      if _280:
        xs200 = (_1217).forward(x16, )
      else:
        xs201 = torch.add_(xs196, (_1217).forward(x16, ))
        xs200 = xs201
      xs199 = xs200
    else:
      xs199 = xs196
    num_kernels208 = self.num_kernels
    _281 = torch.le(torch.mul(2, num_kernels208), 2)
    if _281:
      num_kernels209 = self.num_kernels
      _283 = torch.lt(2, torch.mul(3, num_kernels209))
      _282 = _283
    else:
      _282 = False
    if _282:
      num_kernels210 = self.num_kernels
      _284 = torch.eq(torch.mul(2, num_kernels210), 2)
      if _284:
        xs203 = (_2215).forward(x16, )
      else:
        xs204 = torch.add_(xs199, (_2215).forward(x16, ))
        xs203 = xs204
      xs202 = xs203
    else:
      xs202 = xs199
    num_kernels211 = self.num_kernels
    _285 = torch.le(torch.mul(2, num_kernels211), 3)
    if _285:
      num_kernels212 = self.num_kernels
      _287 = torch.lt(3, torch.mul(3, num_kernels212))
      _286 = _287
    else:
      _286 = False
    if _286:
      num_kernels213 = self.num_kernels
      _288 = torch.eq(torch.mul(2, num_kernels213), 3)
      if _288:
        xs206 = (_3209).forward(x16, )
      else:
        xs207 = torch.add_(xs202, (_3209).forward(x16, ))
        xs206 = xs207
      xs205 = xs206
    else:
      xs205 = xs202
    num_kernels214 = self.num_kernels
    _289 = torch.le(torch.mul(2, num_kernels214), 4)
    if _289:
      num_kernels215 = self.num_kernels
      _291 = torch.lt(4, torch.mul(3, num_kernels215))
      _290 = _291
    else:
      _290 = False
    if _290:
      num_kernels216 = self.num_kernels
      _292 = torch.eq(torch.mul(2, num_kernels216), 4)
      if _292:
        xs209 = (_4204).forward(x16, )
      else:
        xs210 = torch.add_(xs205, (_4204).forward(x16, ))
        xs209 = xs210
      xs208 = xs209
    else:
      xs208 = xs205
    num_kernels217 = self.num_kernels
    _293 = torch.le(torch.mul(2, num_kernels217), 5)
    if _293:
      num_kernels218 = self.num_kernels
      _295 = torch.lt(5, torch.mul(3, num_kernels218))
      _294 = _295
    else:
      _294 = False
    if _294:
      num_kernels219 = self.num_kernels
      _296 = torch.eq(torch.mul(2, num_kernels219), 5)
      if _296:
        xs212 = (_5202).forward(x16, )
      else:
        xs213 = torch.add_(xs208, (_5202).forward(x16, ))
        xs212 = xs213
      xs211 = xs212
    else:
      xs211 = xs208
    num_kernels220 = self.num_kernels
    _297 = torch.le(torch.mul(2, num_kernels220), 6)
    if _297:
      num_kernels221 = self.num_kernels
      _299 = torch.lt(6, torch.mul(3, num_kernels221))
      _298 = _299
    else:
      _298 = False
    if _298:
      num_kernels222 = self.num_kernels
      _300 = torch.eq(torch.mul(2, num_kernels222), 6)
      if _300:
        xs215 = (_6159).forward(x16, )
      else:
        xs216 = torch.add_(xs211, (_6159).forward(x16, ))
        xs215 = xs216
      xs214 = xs215
    else:
      xs214 = xs211
    num_kernels223 = self.num_kernels
    _301 = torch.le(torch.mul(2, num_kernels223), 7)
    if _301:
      num_kernels224 = self.num_kernels
      _303 = torch.lt(7, torch.mul(3, num_kernels224))
      _302 = _303
    else:
      _302 = False
    if _302:
      num_kernels225 = self.num_kernels
      _304 = torch.eq(torch.mul(2, num_kernels225), 7)
      if _304:
        xs218 = (_7155).forward(x16, )
      else:
        xs219 = torch.add_(xs214, (_7155).forward(x16, ))
        xs218 = xs219
      xs217 = xs218
    else:
      xs217 = xs214
    num_kernels226 = self.num_kernels
    _305 = torch.le(torch.mul(2, num_kernels226), 8)
    if _305:
      num_kernels227 = self.num_kernels
      _307 = torch.lt(8, torch.mul(3, num_kernels227))
      _306 = _307
    else:
      _306 = False
    if _306:
      num_kernels228 = self.num_kernels
      _308 = torch.eq(torch.mul(2, num_kernels228), 8)
      if _308:
        xs221 = (_8117).forward(x16, )
      else:
        xs222 = torch.add_(xs217, (_8117).forward(x16, ))
        xs221 = xs222
      xs220 = xs221
    else:
      xs220 = xs217
    num_kernels229 = self.num_kernels
    x17 = torch.div(xs220, num_kernels229)
    activation_post = self.activation_post
    x18 = (activation_post).forward(x17, )
    conv_post = self.conv_post
    x19 = (conv_post).forward(x18, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _309 = torch.tanh(x19)
    else:
      _309 = (self).pqmf_synthesis(x19, )
    return _309
  def _forward_8(self: __torch__.vocoder.hifigan.jit_vocoder.JitGenerator,
    x: Tensor) -> Tensor:
    conv_pre = self.conv_pre
    _0 = getattr(conv_pre, "0")
    x20 = (_0).forward(x, )
    ups_8 = self.ups_8
    _0215 = getattr(ups_8, "0")
    _1 = getattr(ups_8, "1")
    activation_ups_8 = self.activation_ups_8
    _0216 = getattr(activation_ups_8, "0")
    _1218 = getattr(activation_ups_8, "1")
    x21 = (_0215).forward((_0216).forward(x20, ), None, )
    resblocks_8 = self.resblocks_8
    _0217 = getattr(resblocks_8, "0")
    _1219 = getattr(resblocks_8, "1")
    _2 = getattr(resblocks_8, "2")
    _3 = getattr(resblocks_8, "3")
    _4 = getattr(resblocks_8, "4")
    _5 = getattr(resblocks_8, "5")
    num_kernels = self.num_kernels
    _310 = torch.le(torch.mul(0, num_kernels), 0)
    if _310:
      num_kernels230 = self.num_kernels
      _312 = torch.lt(0, torch.mul(1, num_kernels230))
      _311 = _312
    else:
      _311 = False
    if _311:
      num_kernels231 = self.num_kernels
      _313 = torch.eq(torch.mul(0, num_kernels231), 0)
      if _313:
        xs223 = (_0217).forward(x21, )
      else:
        xs224 = torch.add_(x21, (_0217).forward(x21, ))
        xs223 = xs224
      xs = xs223
    else:
      xs = x21
    num_kernels232 = self.num_kernels
    _314 = torch.le(torch.mul(0, num_kernels232), 1)
    if _314:
      num_kernels233 = self.num_kernels
      _316 = torch.lt(1, torch.mul(1, num_kernels233))
      _315 = _316
    else:
      _315 = False
    if _315:
      num_kernels234 = self.num_kernels
      _317 = torch.eq(torch.mul(0, num_kernels234), 1)
      if _317:
        xs226 = (_1219).forward(x21, )
      else:
        xs227 = torch.add_(xs, (_1219).forward(x21, ))
        xs226 = xs227
      xs225 = xs226
    else:
      xs225 = xs
    num_kernels235 = self.num_kernels
    _318 = torch.le(torch.mul(0, num_kernels235), 2)
    if _318:
      num_kernels236 = self.num_kernels
      _320 = torch.lt(2, torch.mul(1, num_kernels236))
      _319 = _320
    else:
      _319 = False
    if _319:
      num_kernels237 = self.num_kernels
      _321 = torch.eq(torch.mul(0, num_kernels237), 2)
      if _321:
        xs229 = (_2).forward(x21, )
      else:
        xs230 = torch.add_(xs225, (_2).forward(x21, ))
        xs229 = xs230
      xs228 = xs229
    else:
      xs228 = xs225
    num_kernels238 = self.num_kernels
    _322 = torch.le(torch.mul(0, num_kernels238), 3)
    if _322:
      num_kernels239 = self.num_kernels
      _324 = torch.lt(3, torch.mul(1, num_kernels239))
      _323 = _324
    else:
      _323 = False
    if _323:
      num_kernels240 = self.num_kernels
      _325 = torch.eq(torch.mul(0, num_kernels240), 3)
      if _325:
        xs232 = (_3).forward(x21, )
      else:
        xs233 = torch.add_(xs228, (_3).forward(x21, ))
        xs232 = xs233
      xs231 = xs232
    else:
      xs231 = xs228
    num_kernels241 = self.num_kernels
    _326 = torch.le(torch.mul(0, num_kernels241), 4)
    if _326:
      num_kernels242 = self.num_kernels
      _328 = torch.lt(4, torch.mul(1, num_kernels242))
      _327 = _328
    else:
      _327 = False
    if _327:
      num_kernels243 = self.num_kernels
      _329 = torch.eq(torch.mul(0, num_kernels243), 4)
      if _329:
        xs235 = (_4).forward(x21, )
      else:
        xs236 = torch.add_(xs231, (_4).forward(x21, ))
        xs235 = xs236
      xs234 = xs235
    else:
      xs234 = xs231
    num_kernels244 = self.num_kernels
    _330 = torch.le(torch.mul(0, num_kernels244), 5)
    if _330:
      num_kernels245 = self.num_kernels
      _332 = torch.lt(5, torch.mul(1, num_kernels245))
      _331 = _332
    else:
      _331 = False
    if _331:
      num_kernels246 = self.num_kernels
      _333 = torch.eq(torch.mul(0, num_kernels246), 5)
      if _333:
        xs238 = (_5).forward(x21, )
      else:
        xs239 = torch.add_(xs234, (_5).forward(x21, ))
        xs238 = xs239
      xs237 = xs238
    else:
      xs237 = xs234
    num_kernels247 = self.num_kernels
    x22 = torch.div(xs237, num_kernels247)
    x23 = (_1).forward((_1218).forward(x22, ), None, )
    resblocks_80 = self.resblocks_8
    _0218 = getattr(resblocks_80, "0")
    _1220 = getattr(resblocks_80, "1")
    _2216 = getattr(resblocks_80, "2")
    _3210 = getattr(resblocks_80, "3")
    _4205 = getattr(resblocks_80, "4")
    _5203 = getattr(resblocks_80, "5")
    num_kernels248 = self.num_kernels
    _334 = torch.le(torch.mul(1, num_kernels248), 0)
    if _334:
      num_kernels249 = self.num_kernels
      _336 = torch.lt(0, torch.mul(2, num_kernels249))
      _335 = _336
    else:
      _335 = False
    if _335:
      num_kernels250 = self.num_kernels
      _337 = torch.eq(torch.mul(1, num_kernels250), 0)
      if _337:
        xs241 = (_0218).forward(x23, )
      else:
        xs242 = torch.add_(x23, (_0218).forward(x23, ))
        xs241 = xs242
      xs240 = xs241
    else:
      xs240 = x23
    num_kernels251 = self.num_kernels
    _338 = torch.le(torch.mul(1, num_kernels251), 1)
    if _338:
      num_kernels252 = self.num_kernels
      _340 = torch.lt(1, torch.mul(2, num_kernels252))
      _339 = _340
    else:
      _339 = False
    if _339:
      num_kernels253 = self.num_kernels
      _341 = torch.eq(torch.mul(1, num_kernels253), 1)
      if _341:
        xs244 = (_1220).forward(x23, )
      else:
        xs245 = torch.add_(xs240, (_1220).forward(x23, ))
        xs244 = xs245
      xs243 = xs244
    else:
      xs243 = xs240
    num_kernels254 = self.num_kernels
    _342 = torch.le(torch.mul(1, num_kernels254), 2)
    if _342:
      num_kernels255 = self.num_kernels
      _344 = torch.lt(2, torch.mul(2, num_kernels255))
      _343 = _344
    else:
      _343 = False
    if _343:
      num_kernels256 = self.num_kernels
      _345 = torch.eq(torch.mul(1, num_kernels256), 2)
      if _345:
        xs247 = (_2216).forward(x23, )
      else:
        xs248 = torch.add_(xs243, (_2216).forward(x23, ))
        xs247 = xs248
      xs246 = xs247
    else:
      xs246 = xs243
    num_kernels257 = self.num_kernels
    _346 = torch.le(torch.mul(1, num_kernels257), 3)
    if _346:
      num_kernels258 = self.num_kernels
      _348 = torch.lt(3, torch.mul(2, num_kernels258))
      _347 = _348
    else:
      _347 = False
    if _347:
      num_kernels259 = self.num_kernels
      _349 = torch.eq(torch.mul(1, num_kernels259), 3)
      if _349:
        xs250 = (_3210).forward(x23, )
      else:
        xs251 = torch.add_(xs246, (_3210).forward(x23, ))
        xs250 = xs251
      xs249 = xs250
    else:
      xs249 = xs246
    num_kernels260 = self.num_kernels
    _350 = torch.le(torch.mul(1, num_kernels260), 4)
    if _350:
      num_kernels261 = self.num_kernels
      _352 = torch.lt(4, torch.mul(2, num_kernels261))
      _351 = _352
    else:
      _351 = False
    if _351:
      num_kernels262 = self.num_kernels
      _353 = torch.eq(torch.mul(1, num_kernels262), 4)
      if _353:
        xs253 = (_4205).forward(x23, )
      else:
        xs254 = torch.add_(xs249, (_4205).forward(x23, ))
        xs253 = xs254
      xs252 = xs253
    else:
      xs252 = xs249
    num_kernels263 = self.num_kernels
    _354 = torch.le(torch.mul(1, num_kernels263), 5)
    if _354:
      num_kernels264 = self.num_kernels
      _356 = torch.lt(5, torch.mul(2, num_kernels264))
      _355 = _356
    else:
      _355 = False
    if _355:
      num_kernels265 = self.num_kernels
      _357 = torch.eq(torch.mul(1, num_kernels265), 5)
      if _357:
        xs256 = (_5203).forward(x23, )
      else:
        xs257 = torch.add_(xs252, (_5203).forward(x23, ))
        xs256 = xs257
      xs255 = xs256
    else:
      xs255 = xs252
    num_kernels266 = self.num_kernels
    x24 = torch.div(xs255, num_kernels266)
    activation_post = self.activation_post
    x25 = (activation_post).forward(x24, )
    conv_post = self.conv_post
    x26 = (conv_post).forward(x25, )
    multiband = self.multiband
    if torch.__not__(multiband):
      _358 = torch.tanh(x26)
    else:
      _358 = (self).pqmf_synthesis(x26, )
    return _358
